/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$;
import eu.dnetlib.dhp.datacite.DataciteUtilityTest$;
import eu.dnetlib.dhp.datacite.GenerateDataciteDatasetSpark;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001]4AAD\b\u00011!)q\u0004\u0001C\u0001A!91\u0005\u0001a\u0001\n\u0013!\u0003bB\u0018\u0001\u0001\u0004%I\u0001\r\u0005\u0007s\u0001\u0001\u000b\u0015B\u0013\t\u000fi\u0002!\u0019!C\u0001w!1A\t\u0001Q\u0001\nqBQ!\u0012\u0001\u0005\u0002\u0019CQA\u0015\u0001\u0005\u0002\u0019CQa\u0016\u0001\u0005\u0002aCQ!\u0018\u0001\u0005\u0002\u0019CQa\u0018\u0001\u0005\u0002\u0019CQ!\u0019\u0001\u0005\u0002\u0019CQa\u0019\u0001\u0005\u0002\u0019\u0013\u0011\u0003R1uC\u000eLG/\u001a+p\u001f\u00063E+Z:u\u0015\t\u0001\u0012#\u0001\u0005eCR\f7-\u001b;f\u0015\t\u00112#A\u0002eQBT!\u0001F\u000b\u0002\u000f\u0011tW\r\u001e7jE*\ta#\u0001\u0002fk\u000e\u00011C\u0001\u0001\u001a!\tQR$D\u0001\u001c\u0015\ta\u0012#A\u0006bO\u001e\u0014XmZ1uS>t\u0017B\u0001\u0010\u001c\u0005Y\t%m\u001d;sC\u000e$hk\\2bEVd\u0017M]=UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\"!\t\u0011\u0003!D\u0001\u0010\u0003)9xN]6j]\u001e$\u0015N]\u000b\u0002KA\u0011a%L\u0007\u0002O)\u0011\u0001&K\u0001\u0005M&dWM\u0003\u0002+W\u0005\u0019a.[8\u000b\u00031\nAA[1wC&\u0011af\n\u0002\u0005!\u0006$\b.\u0001\bx_J\\\u0017N\\4ESJ|F%Z9\u0015\u0005E:\u0004C\u0001\u001a6\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$\u0001B+oSRDq\u0001O\u0002\u0002\u0002\u0003\u0007Q%A\u0002yIE\n1b^8sW&tw\rR5sA\u0005\u0019An\\4\u0016\u0003q\u0002\"!\u0010\"\u000e\u0003yR!a\u0010!\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\u000b1a\u001c:h\u0013\t\u0019eH\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0003tKR,\u0006\u000fF\u00012Q\t9\u0001\n\u0005\u0002J!6\t!J\u0003\u0002L\u0019\u0006\u0019\u0011\r]5\u000b\u00055s\u0015a\u00026va&$XM\u001d\u0006\u0003\u001f\u0002\u000bQA[;oSRL!!\u0015&\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007.\u0001\u0005uK\u0006\u0014Hi\\<oQ\tAA\u000b\u0005\u0002J+&\u0011aK\u0013\u0002\n\u0003\u001a$XM]#bG\"\fq\u0002^3ti\u0012\u000bG/Z'baBLgnZ\u000b\u0002c!\u0012\u0011B\u0017\t\u0003\u0013nK!\u0001\u0018&\u0003\tQ+7\u000f^\u0001\fi\u0016\u001cHoQ8om\u0016\u0014H\u000f\u000b\u0002\u000b5\u0006YA/Z:u\u001b\u0006\u0004\b/\u001b8hQ\tY!,\u0001\u0006uKN$h)\u001b7uKJD#\u0001\u0004.\u0002-Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8HK:,'/\u0019;j_:D#!\u0004.)\t\u00011G.\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S*\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005-D'AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nanI\u0001p!\t\u0001X/D\u0001r\u0015\ti%O\u0003\u0002Pg*\u0011A\u000fQ\u0001\b[>\u001c7.\u001b;p\u0013\t1\u0018O\u0001\tN_\u000e\\\u0017\u000e^8FqR,gn]5p]\u0002")
public class DataciteToOAFTest
extends AbstractVocabularyTest {
    private Path workingDir = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private Path workingDir() {
        return this.workingDir;
    }

    private void workingDir_$eq(Path x$1) {
        this.workingDir = x$1;
    }

    public Logger log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        this.workingDir_$eq(Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]));
        super.setUpVocabulary();
    }

    @AfterEach
    public void tearDown() {
        FileUtils.deleteDirectory((File)this.workingDir().toFile());
    }

    @Test
    public void testDateMapping() {
        String inputDate = "2021-07-14T11:52:54+0000";
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        Date dt = ISO8601FORMAT.parse(inputDate);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)dt.getTime()));
    }

    @Test
    public void testConvert() {
        String path = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/datacite/dataset").getPath();
        SparkConf conf = new SparkConf();
        conf.set("spark.driver.host", "localhost");
        conf.set("spark.ui.enabled", "false");
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master("local[*]").getOrCreate();
        Encoder oafEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Oaf.class));
        GenerateDataciteDatasetSpark instance = new GenerateDataciteDatasetSpark(null, null, this.log());
        String targetPath = new StringBuilder(7).append(this.workingDir()).append("/result").toString();
        instance.generateDataciteDataset(path, true, this.vocabularies, targetPath, spark);
        long nativeSize = spark.read().text(path).count();
        Assertions.assertEquals((long)1502L, (long)nativeSize);
        Dataset relDs = spark.read().schema("source STRING, target STRING, relClass STRING").json(path).where("relClass IS NOT NULL");
        relDs.show(false);
        Dataset result = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).map((Function1 & Serializable & scala.Serializable)input -> DataciteUtilityTest$.MODULE$.convertToOAF((String)input), Encoders$.MODULE$.STRING());
        result.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value").alias("class")})).agg(functions$.MODULE$.count("value").alias("Total"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).show(false);
        long t = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).count();
        Assertions.assertTrue((t > 0L ? 1 : 0) != 0);
        spark.stop();
    }

    @Test
    public void testMapping() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        res.foreach((Function1 & Serializable & scala.Serializable)r -> {
            DataciteToOAFTest.$anonfun$testMapping$1(mapper, r);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testFilter() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record_fairsharing.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        Assertions.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testRelationGeneration() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        ((List)((List)res.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTest.$anonfun$testRelationGeneration$1(s)))).map((Function1 & Serializable & scala.Serializable)s -> (Relation)s, List$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)r -> {
            DataciteToOAFTest.$anonfun$testRelationGeneration$3(r);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testMapping$1(ObjectMapper mapper$1, Oaf r) {
        Predef$.MODULE$.println((Object)mapper$1.writeValueAsString((Object)r));
        Predef$.MODULE$.println((Object)"----------------------------");
    }

    public static final /* synthetic */ boolean $anonfun$testRelationGeneration$1(Oaf s) {
        return s instanceof Relation;
    }

    public static final /* synthetic */ void $anonfun$testRelationGeneration$3(Relation r) {
        Assertions.assertNotNull((Object)r.getSource());
        Assertions.assertNotNull((Object)r.getTarget());
        Assertions.assertNotNull((Object)r.getRelClass());
        Assertions.assertNotNull((Object)r.getCollectedfrom());
        Assertions.assertTrue((boolean)r.getSource().startsWith("50|"));
        Assertions.assertTrue((boolean)r.getTarget().startsWith("50|"));
    }
}

