/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.bipaffiliations;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.bipaffiliations.PrepareAffiliationRelations;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareAffiliationRelationsTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final String ID_PREFIX = "50|doi_________::";
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareAffiliationRelationsTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("Using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareAffiliationRelationsTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareAffiliationRelationsTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testMatch() throws Exception {
        String crossrefAffiliationRelationPathNew = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipaffiliations/doi_to_ror.json").getPath();
        String crossrefAffiliationRelationPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipaffiliations/doi_to_ror_old.json").getPath();
        String publisherAffiliationRelationPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipaffiliations/publishers").getPath();
        String publisherAffiliationRelationOldPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/bipaffiliations/publichers_old").getPath();
        String outputPath = workingDir.toString() + "/actionSet";
        PrepareAffiliationRelations.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-crossrefInputPath", crossrefAffiliationRelationPathNew, "-pubmedInputPath", crossrefAffiliationRelationPath, "-openapcInputPath", crossrefAffiliationRelationPathNew, "-dataciteInputPath", crossrefAffiliationRelationPathNew, "-webCrawlInputPath", crossrefAffiliationRelationPathNew, "-publisherInputPath", publisherAffiliationRelationPath, "-outputPath", outputPath});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(outputPath, Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        Assertions.assertEquals((long)162L, (long)tmp.count());
        Dataset dataset = spark.createDataset(tmp.rdd(), Encoders.bean(Relation.class));
        dataset.createOrReplaceTempView("result");
        Dataset execVerification = spark.sql("select r.relType, r.relClass, r.source, r.target, r.dataInfo.trust from result r");
        Assertions.assertEquals((int)81, (int)execVerification.filter("relClass='hasAuthorInstitution'").collectAsList().size());
        Assertions.assertEquals((int)81, (int)execVerification.filter("relClass='isAuthorInstitutionOf'").collectAsList().size());
        String sourceDOI = "10.1089/10872910260066679";
        String sourceOpenaireId = ID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)sourceDOI));
        Assertions.assertEquals((Object)"1.0", (Object)((Row)execVerification.filter("source='" + sourceOpenaireId + "'").collectAsList().get(0)).getString(4));
        String publisherid = ID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1089/10872910260066679"));
        String rorId = "20|ror_________::" + IdentifierFactory.md5((String)"https://ror.org/05cf8a891");
        Assertions.assertEquals((long)4L, (long)execVerification.filter("source = '" + publisherid + "' and target = '" + rorId + "'").count());
        Assertions.assertEquals((long)1L, (long)execVerification.filter("source = '50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1007/s00217-010-1268-9")) + "' and target = '20|ror_________::" + IdentifierFactory.md5((String)"https://ror.org/03265fv13") + "'").count());
        Assertions.assertEquals((long)1L, (long)execVerification.filter("source = '50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1007/3-540-47984-8_14")) + "' and target = '20|ror_________::" + IdentifierFactory.md5((String)"https://ror.org/00a0n9e72") + "'").count());
    }

    static {
        log = LoggerFactory.getLogger(PrepareAffiliationRelationsTest.class);
    }
}

