/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.webcrawl;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.webcrawl.CreateActionSetFromWebEntries;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateASTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(CreateASTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(CreateASTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(CreateASTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testNumberofRelations() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/input").getPath();
        String blackListPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/blackListRemove").getPath();
        CreateActionSetFromWebEntries.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", inputPath, "-outputPath", workingDir.toString() + "/actionSet_testNumberofRelations", "-blackListPath", blackListPath});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet_testNumberofRelations", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        tmp.foreach((VoidFunction & Serializable)r -> Assertions.assertTrue((r.getSource().startsWith("20|ror") || r.getSource().startsWith("50|doi") ? 1 : 0) != 0));
        tmp.foreach((VoidFunction & Serializable)r -> Assertions.assertTrue((r.getTarget().startsWith("20|ror") || r.getTarget().startsWith("50|doi") ? 1 : 0) != 0));
        Assertions.assertEquals((long)24L, (long)tmp.count());
    }

    @Test
    void testRelations() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/input").getPath();
        String blackListPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/blackListRemove").getPath();
        CreateActionSetFromWebEntries.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", inputPath, "-outputPath", workingDir.toString() + "/actionSet_testRelations", "-blackListPath", blackListPath});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet_testRelations", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> System.out.println(new ObjectMapper().writeValueAsString(r)));
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getSource().equals("50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)"10.1098/rstl.1684.0023")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)"10.1098/rstl.1684.0023")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getSource().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"ROR", (String)"https://ror.org/03argrj65")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"ROR", (String)"https://ror.org/03argrj65")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getSource().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"ROR", (String)"https://ror.org/03265fv13")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"ROR", (String)"https://ror.org/03265fv13")))).count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"ROR", (String)"https://ror.org/03265fv13"))) && r.getSource().startsWith("50|doi")).count());
        Assertions.assertEquals((long)0L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)"https://ror.org/03265fv13"))) && r.getSource().startsWith("50|pmid")).count());
        Assertions.assertEquals((long)0L, (long)tmp.filter((Function & Serializable)r -> r.getTarget().equals("20|ror_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)"https://ror.org/03265fv13"))) && r.getSource().startsWith("50|pmc")).count());
    }

    @Test
    void testRelationsCollectedFrom() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/input").getPath();
        String blackListPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/blackListRemove").getPath();
        CreateActionSetFromWebEntries.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", inputPath, "-outputPath", workingDir.toString() + "/actionSet_testRelationsCollectedFrom", "-blackListPath", blackListPath});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet_testRelationsCollectedFrom", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> {
            Assertions.assertEquals((Object)"Web Crawl", (Object)((KeyValue)r.getCollectedfrom().get(0)).getValue());
            Assertions.assertEquals((Object)"10|openaire____::fb98a192f6a055ba495ef414c330834b", (Object)((KeyValue)r.getCollectedfrom().get(0)).getKey());
        });
    }

    static {
        log = LoggerFactory.getLogger(CreateASTest.class);
    }
}

