/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.opencitations;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetOpenCitationsRefs
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GetOpenCitationsRefs.class);

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(GetOpenCitationsRefs.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/opencitations/input_parameters.json"))));
        parser.parseArgument(args);
        String inputPath = parser.get("inputPath");
        log.info("inputPath {}", (Object)inputPath);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        String backupPath = parser.get("backupPath");
        log.info("backupPath {}", (Object)backupPath);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)conf);
        GetOpenCitationsRefs ocr = new GetOpenCitationsRefs();
        ocr.doExtract(inputPath, outputPath, backupPath, fileSystem);
    }

    private void doExtract(String inputPath, String outputPath, String backupPath, FileSystem fileSystem) throws IOException {
        RemoteIterator fileStatusListIterator = fileSystem.listFiles(new Path(inputPath), true);
        while (fileStatusListIterator.hasNext()) {
            LocatedFileStatus fileStatus = (LocatedFileStatus)fileStatusListIterator.next();
            FSDataInputStream oc_zip = fileSystem.open(fileStatus.getPath());
            try (ZipInputStream zis = new ZipInputStream((InputStream)oc_zip);){
                ZipEntry entry = null;
                while ((entry = zis.getNextEntry()) != null) {
                    if (entry.isDirectory()) continue;
                    String fileName = entry.getName();
                    fileName = fileName.substring(0, fileName.lastIndexOf("."));
                    FSDataOutputStream out = fileSystem.create(new Path(outputPath + "/" + fileName + ".gz"));
                    try (GZIPOutputStream gzipOs = new GZIPOutputStream(new BufferedOutputStream((OutputStream)out));){
                        IOUtils.copy((InputStream)zis, (OutputStream)gzipOs);
                    }
                    finally {
                        if (out == null) continue;
                        out.close();
                    }
                }
            }
            fileSystem.rename(fileStatus.getPath(), new Path(backupPath));
        }
    }
}

