/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio.pubmed;

import eu.dnetlib.dhp.sx.bio.pubmed.PMAffiliation;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMGrant;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMJournal;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import java.io.Serializable;
import javax.xml.stream.XMLEventReader;
import org.apache.commons.lang3.StringUtils;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.XML$;
import scala.xml.pull.EvElemEnd;
import scala.xml.pull.EvElemStart;
import scala.xml.pull.EvText;

@ScalaSignature(bytes="\u0006\u0005Y4A!\u0003\u0006\u0001/!)a\u0004\u0001C\u0001?!)!\u0005\u0001C\u0005G!)\u0011\b\u0001C\u0005u!)\u0011\t\u0001C\u0005\u0005\")A\u000b\u0001C\u0005+\")1\f\u0001C\u00059\")1\r\u0001C\u0001I\")!\u000e\u0001C\u0001W\nI\u0001+\u0014)beN,'O\r\u0006\u0003\u00171\ta\u0001];c[\u0016$'BA\u0007\u000f\u0003\r\u0011\u0017n\u001c\u0006\u0003\u001fA\t!a\u001d=\u000b\u0005E\u0011\u0012a\u00013ia*\u00111\u0003F\u0001\bI:,G\u000f\\5c\u0015\u0005)\u0012AA3v\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eaR\"\u0001\u000e\u000b\u0003m\tQa]2bY\u0006L!!\b\u000e\u0003\r\u0005s\u0017PU3g\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\t!\"A\tfqR\u0014\u0018m\u0019;BiR\u0014\u0018NY;uKN$2\u0001J\u00188!\t)CF\u0004\u0002'UA\u0011qEG\u0007\u0002Q)\u0011\u0011FF\u0001\u0007yI|w\u000e\u001e \n\u0005-R\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u000e\t\u000bA\u0012\u0001\u0019A\u0019\u0002\u000b\u0005$HO]:\u0011\u0005I*T\"A\u001a\u000b\u0005QR\u0012a\u0001=nY&\u0011ag\r\u0002\t\u001b\u0016$\u0018\rR1uC\")\u0001H\u0001a\u0001I\u0005\u00191.Z=\u0002\u001bY\fG.\u001b3bi\u0016|F)\u0019;f)\u0011!3(P \t\u000bq\u001a\u0001\u0019\u0001\u0013\u0002\te,\u0017M\u001d\u0005\u0006}\r\u0001\r\u0001J\u0001\u0006[>tG\u000f\u001b\u0005\u0006\u0001\u000e\u0001\r\u0001J\u0001\u0004I\u0006L\u0018\u0001D3yiJ\f7\r^$sC:$HCA\"P!\r!\u0015\n\u0014\b\u0003\u000b\u001es!a\n$\n\u0003mI!\u0001\u0013\u000e\u0002\u000fA\f7m[1hK&\u0011!j\u0013\u0002\u0005\u0019&\u001cHO\u0003\u0002I5A\u0011\u0011%T\u0005\u0003\u001d*\u0011q\u0001U'He\u0006tG\u000fC\u0003Q\t\u0001\u0007\u0011+A\u0003h\u001d>$W\r\u0005\u00023%&\u00111k\r\u0002\b\u001d>$WmU3r\u00039)\u0007\u0010\u001e:bGRTu.\u001e:oC2$\"AV-\u0011\u0005\u0005:\u0016B\u0001-\u000b\u0005%\u0001VJS8ve:\fG\u000eC\u0003[\u000b\u0001\u0007\u0011+A\u0003k\u001d>$W-\u0001\bfqR\u0014\u0018m\u0019;BkRDwN]:\u0015\u0005u\u000b\u0007c\u0001#J=B\u0011\u0011eX\u0005\u0003A*\u0011\u0001\u0002U'BkRDwN\u001d\u0005\u0006E\u001a\u0001\r!U\u0001\u0006C:{G-Z\u0001\u0006a\u0006\u00148/\u001a\u000b\u0003K\"\u0004\"!\t4\n\u0005\u001dT!!\u0003)N\u0003J$\u0018n\u00197f\u0011\u0015Iw\u00011\u0001%\u0003\u0015Ig\u000e];u\u0003\u0019\u0001\u0018M]:feQ\u0011Q\r\u001c\u0005\u0006i!\u0001\r!\u001c\t\u0003]Rl\u0011a\u001c\u0006\u0003aF\faa\u001d;sK\u0006l'B\u0001\u001bs\u0015\u0005\u0019\u0018!\u00026bm\u0006D\u0018BA;p\u00059AV\nT#wK:$(+Z1eKJ\u0004")
public class PMParser2 {
    private String extractAttributes(MetaData attrs, String key) {
        Option res = attrs.get(key);
        if (res.isDefined()) {
            Seq s = (Seq)res.get();
            if (s != null && s.nonEmpty()) {
                return ((Node)s.head()).text();
            }
            return null;
        }
        return null;
    }

    private String validate_Date(String year, String month, String day) {
        String string;
        try {
            string = StringOps$.MODULE$.format$extension("%s-%02d-%02d", (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(year))), BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(month))), BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(day)))}));
        }
        catch (Throwable throwable) {
            string = null;
        }
        return string;
    }

    private List<PMGrant> extractGrant(NodeSeq gNode) {
        return ((IterableOnceOps)gNode.map((Function1 & Serializable)node -> {
            String grantId = node.$bslash("GrantID").text();
            String agency = node.$bslash("Agency").text();
            String country = node.$bslash("Country").text();
            return new PMGrant(grantId, agency, country);
        })).toList();
    }

    private PMJournal extractJournal(NodeSeq jNode) {
        PMJournal journal = new PMJournal();
        journal.setTitle(jNode.$bslash("Title").text());
        journal.setIssn(jNode.$bslash("ISSN").text());
        journal.setVolume(jNode.$bslash("JournalIssue").$bslash("Volume").text());
        journal.setIssue(jNode.$bslash("JournalIssue").$bslash("Issue").text());
        if (journal.getTitle() != null && StringUtils.isNotEmpty((CharSequence)journal.getTitle())) {
            return journal;
        }
        return null;
    }

    private List<PMAuthor> extractAuthors(NodeSeq aNode) {
        return ((IterableOnceOps)aNode.map((Function1 & Serializable)author -> {
            PMAuthor a;
            block2: {
                a = new PMAuthor();
                a.setLastName(author.$bslash("LastName").text());
                a.setForeName(author.$bslash("ForeName").text());
                String id = author.$bslash("Identifier").text();
                String idType = author.$bslash("Identifier").$bslash("@Source").text();
                if (id != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(id)) && idType != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(idType))) {
                    a.setIdentifier(new PMIdentifier(id, idType));
                }
                String affiliation = author.$bslash("AffiliationInfo").$bslash("Affiliation").text();
                String affiliationId = author.$bslash("AffiliationInfo").$bslash("Identifier").text();
                String affiliationIdType = author.$bslash("AffiliationInfo").$bslash("Identifier").$bslash("@Source").text();
                if (affiliation == null || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(affiliation))) break block2;
                PMAffiliation aff = new PMAffiliation();
                aff.setName(affiliation);
                if (affiliationId != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(affiliationId)) && affiliationIdType != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(affiliationIdType))) {
                    aff.setIdentifier(new PMIdentifier(affiliationId, affiliationIdType));
                }
                a.setAffiliation(aff);
            }
            return a;
        })).toList();
    }

    public PMArticle parse(String input) {
        Elem xml = (Elem)XML$.MODULE$.loadString(input);
        PMArticle article = new PMArticle();
        NodeSeq grantNodes = xml.$bslash("MedlineCitation").$bslash$bslash("Grant");
        article.setGrants((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.extractGrant(grantNodes)).asJava());
        NodeSeq journal = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("Journal");
        article.setJournal(this.extractJournal(journal));
        NodeSeq authors = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("AuthorList").$bslash("Author");
        article.setAuthors((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.extractAuthors(authors)).asJava());
        NodeSeq pmId = xml.$bslash("MedlineCitation").$bslash("PMID");
        NodeSeq articleIds = xml.$bslash("PubmedData").$bslash("ArticleIdList").$bslash("ArticleId");
        articleIds.foreach((Function1 & Serializable)articleId -> {
            PMParser2.$anonfun$parse$1(article, articleId);
            return BoxedUnit.UNIT;
        });
        article.setPmid(pmId.text());
        NodeSeq pubMedPubDate = xml.$bslash("MedlineCitation").$bslash("DateCompleted");
        String currentDate = this.validate_Date(pubMedPubDate.$bslash("Year").text(), pubMedPubDate.$bslash("Month").text(), pubMedPubDate.$bslash("Day").text());
        if (currentDate != null) {
            article.setDate(currentDate);
        }
        NodeSeq articleTitle = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("ArticleTitle");
        article.setTitle(articleTitle.text());
        NodeSeq abstractText = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("Abstract").$bslash("AbstractText");
        if (abstractText != null && abstractText.text() != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(abstractText.text()))) {
            article.setDescription(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])abstractText.text().split("\n")), (Function1 & Serializable)s -> s.trim(), ClassTag$.MODULE$.apply(String.class))).mkString(" ").trim());
        }
        NodeSeq language = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("Language");
        article.setLanguage(language.text());
        NodeSeq subjects = xml.$bslash("MedlineCitation").$bslash("MeshHeadingList").$bslash("MeshHeading");
        article.setSubjects((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)((StrictOptimizedIterableOps)subjects.take(20)).map((Function1 & Serializable)subject -> {
            String descriptorName = subject.$bslash("DescriptorName").text();
            String ui = subject.$bslash("DescriptorName").$bslash("@UI").text();
            PMSubject s = new PMSubject();
            s.setValue(descriptorName);
            s.setMeshId(ui);
            return s;
        })).toList()).asJava());
        NodeSeq publicationTypes = xml.$bslash("MedlineCitation").$bslash("Article").$bslash("PublicationTypeList").$bslash("PublicationType");
        article.setPublicationTypes((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((IterableOnceOps)publicationTypes.map((Function1 & Serializable)pt -> {
            PMSubject s = new PMSubject();
            s.setValue(pt.text());
            return s;
        })).toList()).asJava());
        return article;
    }

    public PMArticle parse2(XMLEventReader xml) {
        PMArticle currentArticle = null;
        PMSubject currentSubject = null;
        PMAuthor currentAuthor = null;
        PMJournal currentJournal = null;
        PMGrant currentGrant = null;
        String currNode = null;
        String currentYear = "0";
        String currentMonth = "01";
        String currentDay = "01";
        String currentArticleType = null;
        block40: while (xml.hasNext()) {
            Object ne = xml.next();
            Object e = ne;
            if (e instanceof EvElemStart) {
                EvElemStart evElemStart = (EvElemStart)e;
                String label = evElemStart.label();
                MetaData attrs = evElemStart.attrs();
                currNode = label;
                String string = label;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1731489647: {
                        if ("ArticleId".equals(string)) {
                            currentArticleType = this.extractAttributes(attrs, "IdType");
                        }
                        continue block40;
                    }
                    case -380944710: {
                        if (!"DescriptorName".equals(string)) continue block40;
                        break;
                    }
                    case 69062908: {
                        if (!"Grant".equals(string)) continue block40;
                        currentGrant = new PMGrant();
                        continue block40;
                    }
                    case 245188375: {
                        if (!"Journal".equals(string)) continue block40;
                        currentJournal = new PMJournal();
                        continue block40;
                    }
                    case 474048358: {
                        if (!"PublicationType".equals(string)) continue block40;
                        break;
                    }
                    case 1518005287: {
                        if (!"PubmedArticle".equals(string)) continue block40;
                        currentArticle = new PMArticle();
                        continue block40;
                    }
                    case 1972506027: {
                        if (!"Author".equals(string)) continue block40;
                        currentAuthor = new PMAuthor();
                        continue block40;
                    }
                    default: {
                        continue block40;
                    }
                }
                currentSubject = new PMSubject();
                currentSubject.setMeshId(this.extractAttributes(attrs, "UI"));
                continue;
            }
            if (e instanceof EvElemEnd) {
                EvElemEnd evElemEnd = (EvElemEnd)e;
                String label = evElemEnd.label();
                String string = label;
                switch (string == null ? 0 : string.hashCode()) {
                    case -380944710: {
                        if (!"DescriptorName".equals(string)) break;
                        BoxesRunTime.boxToBoolean((boolean)currentArticle.getSubjects().add(currentSubject));
                        continue block40;
                    }
                    case -287683684: {
                        if (!"PubMedPubDate".equals(string)) break;
                        if (currentArticle.getDate() == null) {
                            currentArticle.setDate(this.validate_Date(currentYear, currentMonth, currentDay));
                        }
                        continue block40;
                    }
                    case 69062908: {
                        if (!"Grant".equals(string)) break;
                        BoxesRunTime.boxToBoolean((boolean)currentArticle.getGrants().add(currentGrant));
                        continue block40;
                    }
                    case 245188375: {
                        if (!"Journal".equals(string)) break;
                        currentArticle.setJournal(currentJournal);
                        continue block40;
                    }
                    case 474048358: {
                        if (!"PublicationType".equals(string)) break;
                        BoxesRunTime.boxToBoolean((boolean)currentArticle.getPublicationTypes().add(currentSubject));
                        continue block40;
                    }
                    case 1428088875: {
                        if (!"PubDate".equals(string)) break;
                        currentJournal.setDate(currentYear + "-" + currentMonth + "-" + currentDay);
                        continue block40;
                    }
                    case 1518005287: {
                        if (!"PubmedArticle".equals(string)) break;
                        return currentArticle;
                    }
                    case 1972506027: {
                        if (!"Author".equals(string)) break;
                        BoxesRunTime.boxToBoolean((boolean)currentArticle.getAuthors().add(currentAuthor));
                        continue block40;
                    }
                }
                continue;
            }
            if (!(e instanceof EvText)) continue;
            EvText evText = (EvText)e;
            String text = evText.text();
            if (currNode == null || !StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(text.trim()))) continue;
            String string = currNode;
            switch (string == null ? 0 : string.hashCode()) {
                case -1731489647: {
                    if (!"ArticleId".equals(string)) continue block40;
                    if ("doi".equalsIgnoreCase(currentArticleType)) {
                        currentArticle.setDoi(text.trim());
                    }
                    if (!"pmc".equalsIgnoreCase(currentArticleType)) continue block40;
                    currentArticle.setPmcId(text.trim());
                    continue block40;
                }
                case -1727016134: {
                    if (!"Volume".equals(string)) continue block40;
                    currentJournal.setVolume(text.trim());
                    continue block40;
                }
                case -1672482954: {
                    if (!"Country".equals(string)) continue block40;
                    if (currentGrant == null) continue block40;
                    currentGrant.setCountry(text.trim());
                    continue block40;
                }
                case -1548945544: {
                    if (!"Language".equals(string)) continue block40;
                    currentArticle.setLanguage(text.trim());
                    continue block40;
                }
                case -1394955679: {
                    if (!"LastName".equals(string)) continue block40;
                    if (currentAuthor == null) continue block40;
                    currentAuthor.setLastName(text.trim());
                    continue block40;
                }
                case -593224561: {
                    if (!"AbstractText".equals(string)) continue block40;
                    if (currentArticle.getDescription() == null) {
                        currentArticle.setDescription(text.trim());
                        continue block40;
                    }
                    currentArticle.setDescription(currentArticle.getDescription() + text.trim());
                    continue block40;
                }
                case -380944710: {
                    if (!"DescriptorName".equals(string)) continue block40;
                    break;
                }
                case -240426206: {
                    if (!"ArticleTitle".equals(string)) continue block40;
                    if (currentArticle.getTitle() == null) {
                        currentArticle.setTitle(text.trim());
                        continue block40;
                    }
                    currentArticle.setTitle(currentArticle.getTitle() + text.trim());
                    continue block40;
                }
                case 68476: {
                    if (!"Day".equals(string)) continue block40;
                    currentDay = text.trim();
                    continue block40;
                }
                case 2257157: {
                    if (!"ISSN".equals(string)) continue block40;
                    currentJournal.setIssn(text.trim());
                    continue block40;
                }
                case 2459608: {
                    if (!"PMID".equals(string)) continue block40;
                    currentArticle.setPmid(text.trim());
                    continue block40;
                }
                case 2751581: {
                    if (!"Year".equals(string)) continue block40;
                    currentYear = text.trim();
                    continue block40;
                }
                case 70957241: {
                    if (!"Issue".equals(string)) continue block40;
                    currentJournal.setIssue(text.trim());
                    continue block40;
                }
                case 74527328: {
                    if (!"Month".equals(string)) continue block40;
                    currentMonth = text.trim();
                    continue block40;
                }
                case 80818744: {
                    if (!"Title".equals(string)) continue block40;
                    if (currentJournal.getTitle() == null) {
                        currentJournal.setTitle(text.trim());
                        continue block40;
                    }
                    currentJournal.setTitle(currentJournal.getTitle() + text.trim());
                    continue block40;
                }
                case 474048358: {
                    if (!"PublicationType".equals(string)) continue block40;
                    break;
                }
                case 530751879: {
                    if (!"ForeName".equals(string)) continue block40;
                    if (currentAuthor == null) continue block40;
                    currentAuthor.setForeName(text.trim());
                    continue block40;
                }
                case 1944947479: {
                    if (!"GrantID".equals(string)) continue block40;
                    currentGrant.setGrantID(text.trim());
                    continue block40;
                }
                case 1959135269: {
                    if (!"Agency".equals(string)) continue block40;
                    currentGrant.setAgency(text.trim());
                    continue block40;
                }
                default: {
                    continue block40;
                }
            }
            currentSubject.setValue(text.trim());
        }
        return null;
    }

    public static final /* synthetic */ void $anonfun$parse$1(PMArticle article$1, Node articleId) {
        String idType = articleId.$bslash("@IdType").text();
        String id = articleId.text();
        if ("doi".equalsIgnoreCase(idType)) {
            article$1.setDoi(id);
        }
        if ("pmc".equalsIgnoreCase(idType)) {
            article$1.setPmcId(id);
            return;
        }
    }
}

