/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.PrepareProjectTest;
import eu.dnetlib.dhp.actionmanager.project.utils.ReadProjects;
import eu.dnetlib.dhp.actionmanager.project.utils.model.Project;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadProjectsTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static Path workingDir;
    private static LocalFileSystem fs;
    private static SparkSession spark;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ReadProjectsTest.class.getSimpleName(), new FileAttribute[0]);
        fs = FileSystem.getLocal((Configuration)new Configuration());
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareProjectTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareProjectTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void readProjects() throws IOException {
        String projects = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/projects.json").getPath();
        ReadProjects.readProjects((String)projects, (String)(workingDir.toString() + "/projects"), (FileSystem)fs);
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/projects").map((Function & Serializable)item -> (Project)OBJECT_MAPPER.readValue(item, Project.class));
        Assertions.assertEquals((long)19L, (long)tmp.count());
        Project project = (Project)tmp.filter((Function & Serializable)p -> p.getAcronym().equals("GiSTDS")).first();
        Assertions.assertEquals((Object)"2022-10-08 18:28:27", (Object)project.getContentUpdateDate());
        Assertions.assertEquals((Object)"894593", (Object)project.getId());
        Assertions.assertEquals((Object)"H2020-EU.1.3.", (Object)project.getLegalBasis());
        Assertions.assertEquals((Object)"MSCA-IF-2019", (Object)project.getTopics());
    }

    static {
        log = LoggerFactory.getLogger(ReadProjectsTest.class);
    }
}

