/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.rest;

import com.google.gson.Gson;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.rest.RestCollectorPlugin;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RestCollectorPluginTest {
    private static final Logger log = LoggerFactory.getLogger(RestCollectorPluginTest.class);
    private final String baseUrl = "https://ddh-openapi.worldbank.org/search";
    private final String resumptionType = "discover";
    private final String resumptionParam = "skip";
    private final String entityXpath = "//*[local-name()='data']";
    private final String resumptionXpath = "";
    private final String resultTotalXpath = "//*[local-name()='count']";
    private final String resultFormatParam = "";
    private final String resultFormatValue = "json";
    private final String resultSizeParam = "top";
    private final String resultSizeValue = "10";
    private final String query = "";
    private final String protocolDescriptor = "rest_json2xml";
    private final ApiDescriptor api = new ApiDescriptor();
    private RestCollectorPlugin rcp;

    RestCollectorPluginTest() {
    }

    @BeforeEach
    public void setUp() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("resumptionType", "discover");
        params.put("resumptionParam", "skip");
        params.put("resumptionXpath", "");
        params.put("resultTotalXpath", "//*[local-name()='count']");
        params.put("resultFormatParam", "");
        params.put("resultFormatValue", "json");
        params.put("resultSizeParam", "top");
        params.put("resultSizeValue", "10");
        params.put("queryParams", "");
        params.put("entityXpath", "//*[local-name()='data']");
        params.put("requestHeaderMap", "{\"User-Agent\": \"OpenAIRE DEV\"}");
        this.api.setBaseUrl("https://ddh-openapi.worldbank.org/search");
        this.api.setParams(params);
        this.rcp = new RestCollectorPlugin(new HttpClientParams());
    }

    @Disabled
    @Test
    void test() throws CollectorException {
        AtomicInteger i = new AtomicInteger(0);
        Stream stream = this.rcp.collect(this.api, new AggregatorReport());
        stream.limit(200L).forEach(s -> {
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
            i.incrementAndGet();
            log.info(s);
        });
        log.info("{}", (Object)i.intValue());
        Assertions.assertTrue((i.intValue() > 0 ? 1 : 0) != 0);
    }

    @Disabled
    @Test
    void testUrl() throws IOException {
        String url_s = "https://ddh-openapi.worldbank.org/search?&top=10";
        URL url = new URL(url_s);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setRequestProperty("User-Agent", "OpenAIRE");
        Gson gson = new Gson();
        System.out.println("Request header");
        System.out.println(gson.toJson(conn.getHeaderFields()));
        InputStream inputStream = conn.getInputStream();
    }
}

