/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import eu.dnetlib.dhp.application.AbstractScalaApplication;
import eu.dnetlib.dhp.collection.orcid.SparkApplyUpdate$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005ua\u0001\u0002\t\u0012\u0001qA\u0011b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0019\t\u0013I\u0002!\u0011!Q\u0001\nM:\u0004\u0002\u0003\u001d\u0001\u0005\u0003\u0005\u000b\u0011B\u001d\t\u000b\u0005\u0003A\u0011\u0001\"\t\u000b!\u0003A\u0011I%\t\u000b5\u0003A\u0011\u0002(\t\u000by\u0003A\u0011B0\t\u000b]\u0004A\u0011\u0002=\t\u000bq\u0004A\u0011B?\b\u000f\u0005\u0015\u0011\u0003#\u0001\u0002\b\u00191\u0001#\u0005E\u0001\u0003\u0013Aa!Q\u0006\u0005\u0002\u0005E\u0001\u0002\u0003\u001d\f\u0005\u0004%\t!a\u0005\t\u000f\u0005U1\u0002)A\u0005s!9\u0011qC\u0006\u0005\u0002\u0005e!\u0001E*qCJ\\\u0017\t\u001d9msV\u0003H-\u0019;f\u0015\t\u00112#A\u0003pe\u000eLGM\u0003\u0002\u0015+\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0005Y9\u0012a\u00013ia*\u0011\u0001$G\u0001\bI:,G\u000f\\5c\u0015\u0005Q\u0012AA3v\u0007\u0001\u0019\"\u0001A\u000f\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001*\u0012aC1qa2L7-\u0019;j_:L!AI\u0010\u00031\u0005\u00137\u000f\u001e:bGR\u001c6-\u00197b\u0003B\u0004H.[2bi&|g.\u0001\u0007qe>\u0004XM\u001d;z!\u0006$\b\u000e\u0005\u0002&]9\u0011a\u0005\f\t\u0003O)j\u0011\u0001\u000b\u0006\u0003Sm\ta\u0001\u0010:p_Rt$\"A\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00055R\u0013A\u0002)sK\u0012,g-\u0003\u00020a\t11\u000b\u001e:j]\u001eT!!\f\u0016\n\u0005\r\n\u0013\u0001B1sON\u00042\u0001N\u001b%\u001b\u0005Q\u0013B\u0001\u001c+\u0005\u0015\t%O]1z\u0013\t\u0011\u0014%A\u0002m_\u001e\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000bMdg\r\u000e6\u000b\u0003y\n1a\u001c:h\u0013\t\u00015H\u0001\u0004M_\u001e<WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r+ei\u0012\t\u0003\t\u0002i\u0011!\u0005\u0005\u0006G\u0011\u0001\r\u0001\n\u0005\u0006e\u0011\u0001\ra\r\u0005\u0006q\u0011\u0001\r!O\u0001\u0004eVtG#\u0001&\u0011\u0005QZ\u0015B\u0001'+\u0005\u0011)f.\u001b;\u0002\u00135|g/\u001a+bE2,G\u0003\u0002&P5rCQ\u0001\u0015\u0004A\u0002E\u000bQa\u001d9be.\u0004\"A\u0015-\u000e\u0003MS!\u0001V+\u0002\u0007M\fHN\u0003\u0002Q-*\u0011q+P\u0001\u0007CB\f7\r[3\n\u0005e\u001b&\u0001D*qCJ\\7+Z:tS>t\u0007\"B.\u0007\u0001\u0004!\u0013!C4sCBD\u0007+\u0019;i\u0011\u0015if\u00011\u0001%\u0003))\b\u000fZ1uKB\u000bG\u000f[\u0001\u000ekB$\u0017\r^3ECR\f7/\u001a;\u0015\u000b)\u0003\u0017o];\t\u000b\u0005<\u0001\u0019\u00012\u0002\u0019%t\u0007/\u001e;ECR\f7/\u001a;\u0011\u0005\rtgB\u00013m\u001d\t)7N\u0004\u0002gU:\u0011q-\u001b\b\u0003O!L\u0011AP\u0005\u0003/vJ!\u0001\u0015,\n\u0005Q+\u0016BA7T\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001c9\u0003\u0013\u0011\u000bG/\u0019$sC6,'BA7T\u0011\u0015\u0011x\u00011\u0001c\u0003!IG-\u00169eCR,\u0007\"\u0002;\b\u0001\u0004\u0011\u0017aD;qI\u0006$X\rR1uC\u001a\u0014\u0018-\\3\t\u000bY<\u0001\u0019\u0001\u0013\u0002\u0015Q\f'oZ3u!\u0006$\b.A\u0006dQ\u0016\u001c7.\u00169eCR,G\u0003\u0002&zunDQ\u0001\u0015\u0005A\u0002ECQa\u0017\u0005A\u0002\u0011BQ!\u0018\u0005A\u0002\u0011\n\u0001#\u00199qYf$\u0016M\u00197f+B$\u0017\r^3\u0015\u000f)sx0!\u0001\u0002\u0004!)\u0001+\u0003a\u0001#\")1,\u0003a\u0001I!)Q,\u0003a\u0001I!)a/\u0003a\u0001I\u0005\u00012\u000b]1sW\u0006\u0003\b\u000f\\=Va\u0012\fG/\u001a\t\u0003\t.\u00192aCA\u0006!\r!\u0014QB\u0005\u0004\u0003\u001fQ#AB!osJ+g\r\u0006\u0002\u0002\bU\t\u0011(\u0001\u0003m_\u001e\u0004\u0013\u0001B7bS:$2ASA\u000e\u0011\u0015\u0011t\u00021\u00014\u0001")
public class SparkApplyUpdate
extends AbstractScalaApplication {
    private final Logger log;

    public static void main(String[] args) {
        SparkApplyUpdate$.MODULE$.main(args);
    }

    public void run() {
        String graphPath = this.parser().get("graphPath");
        this.log.info("found parameters graphPath: {}", (Object)graphPath);
        String updatePath = this.parser().get("updatePath");
        this.log.info("found parameters updatePath: {}", (Object)updatePath);
        String targetPath = this.parser().get("targetPath");
        this.log.info("found parameters targetPath: {}", (Object)targetPath);
        this.applyTableUpdate(this.spark(), graphPath, updatePath, targetPath);
        this.checkUpdate(this.spark(), graphPath, targetPath);
        this.moveTable(this.spark(), graphPath, targetPath);
    }

    private void moveTable(SparkSession spark, String graphPath, String updatePath) {
        spark.read().load(updatePath + "/Authors").repartition(1000).write().mode(SaveMode.Overwrite).save(graphPath + "/Authors");
        spark.read().load(updatePath + "/Works").repartition(1000).write().mode(SaveMode.Overwrite).save(graphPath + "/Works");
        spark.read().load(updatePath + "/Employments").repartition(1000).write().mode(SaveMode.Overwrite).save(graphPath + "/Employments");
    }

    private void updateDataset(Dataset<Row> inputDataset, Dataset<Row> idUpdate, Dataset<Row> updateDataframe, String targetPath) {
        inputDataset.join(idUpdate, inputDataset.apply("orcid").equalTo((Object)idUpdate.apply("orcid")), "leftanti").select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{inputDataset.apply("*")})).unionByName(updateDataframe).write().mode(SaveMode.Overwrite).save(targetPath);
    }

    private void checkUpdate(SparkSession spark, String graphPath, String updatePath) {
        long totalOriginalAuthors = spark.read().load(graphPath + "/Authors").count();
        long totalOriginalWorks = spark.read().load(graphPath + "/Works").count();
        long totalOriginalEmployments = spark.read().load(graphPath + "/Employments").count();
        long totalUpdateAuthors = spark.read().load(updatePath + "/Authors").count();
        long totalUpdateWorks = spark.read().load(updatePath + "/Works").count();
        long totalUpdateEmployments = spark.read().load(updatePath + "/Employments").count();
        this.log.info("totalOriginalAuthors: {}", (Object)BoxesRunTime.boxToLong((long)totalOriginalAuthors));
        this.log.info("totalOriginalWorks: {}", (Object)BoxesRunTime.boxToLong((long)totalOriginalWorks));
        this.log.info("totalOriginalEmployments: {}", (Object)BoxesRunTime.boxToLong((long)totalOriginalEmployments));
        this.log.info("totalUpdateAuthors: {}", (Object)BoxesRunTime.boxToLong((long)totalUpdateAuthors));
        this.log.info("totalUpdateWorks: {}", (Object)BoxesRunTime.boxToLong((long)totalUpdateWorks));
        this.log.info("totalUpdateEmployments: {}", (Object)BoxesRunTime.boxToLong((long)totalUpdateEmployments));
        if (totalUpdateAuthors < totalOriginalAuthors || totalUpdateEmployments < totalOriginalEmployments || totalUpdateWorks < totalOriginalWorks) {
            throw new RuntimeException("The updated Graph contains less elements of the original one");
        }
    }

    private void applyTableUpdate(SparkSession spark, String graphPath, String updatePath, String targetPath) {
        Dataset orcidIDUpdate = spark.read().load(updatePath + "/Authors").select("orcid", (Seq)Nil$.MODULE$);
        this.updateDataset((Dataset<Row>)spark.read().load(graphPath + "/Authors"), (Dataset<Row>)orcidIDUpdate, (Dataset<Row>)spark.read().load(updatePath + "/Authors"), targetPath + "/Authors");
        this.updateDataset((Dataset<Row>)spark.read().load(graphPath + "/Employments"), (Dataset<Row>)orcidIDUpdate, (Dataset<Row>)spark.read().load(updatePath + "/Employments"), targetPath + "/Employments");
        this.updateDataset((Dataset<Row>)spark.read().load(graphPath + "/Works"), (Dataset<Row>)orcidIDUpdate, (Dataset<Row>)spark.read().load(updatePath + "/Works"), targetPath + "/Works");
    }

    public SparkApplyUpdate(String propertyPath, String[] args, Logger log) {
        this.log = log;
        super(propertyPath, args, log);
    }
}

