/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.gtr2;

import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.io.InputStream;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Gtr2PublicationsIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(Gtr2PublicationsIterator.class);
    private final HttpConnector2 connector;
    private static final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final int MAX_ATTEMPTS = 10;
    private final String baseUrl;
    private int currPage;
    private int endPage;
    private boolean incremental = false;
    private LocalDate fromDate;
    private final Map<String, String> cache = new HashMap<String, String>();
    private final Queue<String> queue = new LinkedList<String>();
    private String nextElement;

    public Gtr2PublicationsIterator(String baseUrl, String fromDate, String startPage, String endPage, HttpClientParams clientParams) throws CollectorException {
        this.baseUrl = baseUrl;
        this.currPage = NumberUtils.toInt((String)startPage, (int)1);
        this.endPage = NumberUtils.toInt((String)endPage, (int)Integer.MAX_VALUE);
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        this.connector = new HttpConnector2(clientParams);
        if (this.incremental) {
            this.fromDate = this.parseDate(fromDate);
        }
        this.prepareNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            this.prepareNextElement();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void prepareNextElement() {
        while (this.currPage <= this.endPage && this.queue.isEmpty()) {
            log.info("FETCHING PAGE + " + this.currPage + "/" + this.endPage);
            this.queue.addAll(this.fetchPage(this.currPage++));
        }
        this.nextElement = this.queue.poll();
    }

    private List<String> fetchPage(int pageNumber) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            Document doc = this.loadURL(this.baseUrl + "/publication?page=" + pageNumber, 0);
            for (Object po : doc.selectNodes("//*[local-name() = 'publication']")) {
                Element mainEntity = (Element)((Element)po).detach();
                if (this.filterIncremental(mainEntity)) {
                    String publicationOverview = mainEntity.attributeValue("url");
                    res.add(this.loadURL(publicationOverview, -1).asXML());
                    continue;
                }
                log.debug("Skipped entity");
            }
        }
        catch (Throwable e) {
            log.error("Exception fetching page " + pageNumber, e);
            throw new RuntimeException("Exception fetching page " + pageNumber, e);
        }
        return res;
    }

    private boolean filterIncremental(Element e) {
        return !this.incremental || this.isAfter(e.valueOf("@*[local-name() = 'created']"), this.fromDate) || this.isAfter(e.valueOf("@*[local-name() = 'updated']"), this.fromDate);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Document loadURL(String cleanUrl, int attempt) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            Document document;
            block22: {
                HttpGet req = new HttpGet(cleanUrl);
                req.setHeader("Accept", "application/xml");
                CloseableHttpResponse response = client.execute((HttpUriRequest)req);
                try {
                    if (this.endPage == Integer.MAX_VALUE) {
                        for (Header header : response.getAllHeaders()) {
                            log.debug("HEADER: " + header.getName() + " = " + header.getValue());
                            if (!"Link-Pages".equals(header.getName()) || Integer.parseInt(header.getValue()) >= this.endPage) continue;
                            this.endPage = Integer.parseInt(header.getValue());
                        }
                    }
                    String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                    document = DocumentHelper.parseText((String)content);
                    if (response == null) break block22;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return document;
        }
        catch (Throwable e) {
            if (attempt == -1) {
                try {
                    return DocumentHelper.parseText((String)"<empty></empty>");
                }
                catch (Throwable t) {
                    throw new RuntimeException();
                }
            }
            log.error("Error dowloading url: {}, attempt = {}", new Object[]{cleanUrl, attempt, e});
            if (attempt >= 10) {
                throw new RuntimeException("Error downloading url: " + cleanUrl, e);
            }
            try {
                Thread.sleep(60000L);
            }
            catch (InterruptedException e1) {
                throw new RuntimeException("Error downloading url: " + cleanUrl, e);
            }
            return this.loadURL(cleanUrl, attempt + 1);
        }
    }

    private LocalDate parseDate(String s) {
        return LocalDate.parse(s.contains("T") ? s.substring(0, s.indexOf("T")) : s, simpleDateTimeFormatter);
    }

    private boolean isAfter(String d, LocalDate fromDate) {
        return StringUtils.isNotBlank((CharSequence)d) && this.parseDate(d).isAfter(fromDate);
    }
}

