/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.base;

import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.aggregation.common.AggregationCounter;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.dhp.transformation.xslt.XSLTTransformationFunction;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.util.LongAccumulator;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class BaseTransfomationTest
extends AbstractVocabularyTest {
    private SparkConf sparkConf;

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        this.setUpVocabulary();
        this.sparkConf = new SparkConf();
        this.sparkConf.setMaster("local[*]");
        this.sparkConf.set("spark.driver.host", "localhost");
        this.sparkConf.set("spark.ui.enabled", "false");
    }

    @Test
    void testBase2ODF() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("xml/base2odf.transformationRule.xml");
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    void testBase2OAF() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("xml/base2oaf.transformationRule.xml");
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    void testBase2ODF_wrong_date() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("record_wrong_1.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("xml/base2oaf.transformationRule.xml");
        Assertions.assertThrows(NullPointerException.class, () -> {
            MetadataRecord result = tr.call(mr);
            System.out.println(result.getBody());
        });
    }

    private XSLTTransformationFunction loadTransformationRule(String path) throws Exception {
        String xslt = new SAXReader().read(this.getClass().getResourceAsStream(path)).selectSingleNode("//CODE/*").asXML();
        LongAccumulator la = new LongAccumulator();
        return new XSLTTransformationFunction(new AggregationCounter(la, la, la), xslt, 0L, this.vocabularies);
    }
}

