/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.file;

import eu.dnetlib.dhp.collection.plugin.file.AbstractSplittedRecordPlugin;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCollectorPlugin
extends AbstractSplittedRecordPlugin {
    private static final Logger log = LoggerFactory.getLogger(FileCollectorPlugin.class);

    public FileCollectorPlugin(FileSystem fileSystem) {
        super(fileSystem);
    }

    @Override
    protected BufferedInputStream getBufferedInputStream(Path filePath) throws CollectorException {
        log.info("filePath: {}", (Object)filePath);
        try {
            FileSystem fs = super.getFileSystem();
            return new BufferedInputStream((InputStream)fs.open(filePath));
        }
        catch (Exception e) {
            throw new CollectorException("Error reading file " + String.valueOf(filePath), (Throwable)e);
        }
    }
}

