/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.collection.CollectionUtils$;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class SparkTransformBioDatabaseToOAF$ {
    public static final SparkTransformBioDatabaseToOAF$ MODULE$ = new SparkTransformBioDatabaseToOAF$();

    public void main(String[] args) {
        block4: {
            SparkConf conf = new SparkConf();
            Logger log = LoggerFactory.getLogger(this.getClass());
            ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/bio/ebi/bio_to_oaf_params.json")));
            parser.parseArgument(args);
            String database = parser.get("database");
            log.info("database: {}", (Object)database);
            String dbPath = parser.get("dbPath");
            log.info("dbPath: {}", (Object)database);
            String mdstoreOutputVersion = parser.get("mdstoreOutputVersion");
            log.info("mdstoreOutputVersion is '" + mdstoreOutputVersion + "'");
            String isLookupUrl = parser.get("isLookupUrl");
            log.info("isLookupUrl: {}", (Object)isLookupUrl);
            ObjectMapper mapper = new ObjectMapper();
            MDStoreVersion cleanedMdStoreVersion = (MDStoreVersion)mapper.readValue(mdstoreOutputVersion, MDStoreVersion.class);
            String outputBasePath = cleanedMdStoreVersion.getHdfsPath();
            log.info("outputBasePath is '" + outputBasePath + "'");
            ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
            VocabularyGroup vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
            Predef$.MODULE$.require(vocabularies != null);
            SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).getOrCreate();
            SparkContext sc = spark.sparkContext();
            Encoder resultEncoder = Encoders$.MODULE$.kryo(Oaf.class);
            String string = database.toUpperCase();
            switch (string == null ? 0 : string.hashCode()) {
                case 79054: {
                    if (!"PDB".equals(string)) break;
                    CollectionUtils$.MODULE$.saveDataset((Dataset<Oaf>)spark.createDataset(sc.textFile(dbPath, sc.textFile$default$2()).flatMap((Function1 & Serializable)i -> BioDBToOAF$.MODULE$.pdbTOOaf((String)i, vocabularies), ClassTag$.MODULE$.apply(Oaf.class)), resultEncoder), outputBasePath + "/store");
                    long mdStoreSize = spark.read().text(outputBasePath + "/store").count();
                    DHPUtils.writeHdfsFile((Configuration)spark.sparkContext().hadoopConfiguration(), (String)String.valueOf(BoxesRunTime.boxToLong((long)mdStoreSize)), (String)(outputBasePath + "/size"));
                    break block4;
                }
                case 431356983: {
                    if (!"UNIPROT".equals(string)) break;
                    CollectionUtils$.MODULE$.saveDataset((Dataset<Oaf>)spark.createDataset(sc.textFile(dbPath, sc.textFile$default$2()).flatMap((Function1 & Serializable)i -> BioDBToOAF$.MODULE$.uniprotToOAF((String)i, vocabularies), ClassTag$.MODULE$.apply(Oaf.class)), resultEncoder), outputBasePath + "/store");
                    long mdStoreSize = spark.read().text(outputBasePath + "/store").count();
                    DHPUtils.writeHdfsFile((Configuration)spark.sparkContext().hadoopConfiguration(), (String)String.valueOf(BoxesRunTime.boxToLong((long)mdStoreSize)), (String)(outputBasePath + "/size"));
                    break block4;
                }
            }
            throw new MatchError((Object)string);
        }
    }

    private SparkTransformBioDatabaseToOAF$() {
    }
}

