/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.rest;

import com.google.gson.Gson;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.rest.RestIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.util.Map;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;

public class RestCollectorPlugin
implements CollectorPlugin {
    public static final String RESULT_SIZE_VALUE_DEFAULT = "100";
    private final HttpClientParams clientParams;

    public RestCollectorPlugin(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String baseUrl = api.getBaseUrl();
        String resumptionType = (String)api.getParams().get("resumptionType");
        String resumptionParam = (String)api.getParams().get("resumptionParam");
        String resumptionXpath = (String)api.getParams().get("resumptionXpath");
        String resultTotalXpath = (String)api.getParams().get("resultTotalXpath");
        String resultFormatParam = (String)api.getParams().get("resultFormatParam");
        String resultFormatValue = (String)api.getParams().get("resultFormatValue");
        String resultSizeParam = (String)api.getParams().get("resultSizeParam");
        String queryParams = (String)api.getParams().get("queryParams");
        String entityXpath = (String)api.getParams().get("entityXpath");
        String authMethod = (String)api.getParams().get("authMethod");
        String authToken = (String)api.getParams().get("authToken");
        String requestHeaderMap = (String)api.getParams().get("requestHeaderMap");
        Gson gson = new Gson();
        Map requestHeaders = (Map)gson.fromJson(requestHeaderMap, Map.class);
        String resultSizeValue = Optional.ofNullable((String)api.getParams().get("resultSizeValue")).filter(StringUtils::isNotBlank).orElse(RESULT_SIZE_VALUE_DEFAULT);
        if (StringUtils.isBlank((CharSequence)baseUrl)) {
            throw new CollectorException("Param 'baseUrl' is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)resumptionType)) {
            throw new CollectorException("Param 'resumptionType' is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)resumptionParam)) {
            throw new CollectorException("Param 'resumptionParam' is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)resultFormatValue)) {
            throw new CollectorException("Param 'resultFormatValue' is null or empty");
        }
        if (StringUtils.isBlank((CharSequence)entityXpath)) {
            throw new CollectorException("Param 'entityXpath' is null or empty");
        }
        String resultOutputFormat = Optional.ofNullable((String)api.getParams().get("resultOutputFormat")).map(String::toLowerCase).filter(StringUtils::isNotBlank).orElse(resultFormatValue.toLowerCase());
        RestIterator it = new RestIterator(this.getClientParams(), baseUrl, resumptionType, resumptionParam, resumptionXpath, resultTotalXpath, resultFormatParam, resultFormatValue, resultSizeParam, resultSizeValue, queryParams, entityXpath, authMethod, authToken, resultOutputFormat, requestHeaders);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false);
    }

    public HttpClientParams getClientParams() {
        return this.clientParams;
    }
}

