/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSftpIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSftpIterator.class);
    private static final int MAX_RETRIES = 5;
    private static final long BACKOFF_MILLIS = 10000L;
    private String sftpURIScheme;
    private String sftpServerAddress;
    private String remoteSftpBasePath;
    private final int port;
    private final String username;
    private final boolean isRecursive;
    private final Set<String> extensionsSet;
    private final boolean incremental;
    private Session sftpSession;
    private ChannelSftp sftpChannel;
    private Queue<String> queue;
    private LocalDate fromDate = null;
    private final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static String EMPTY_RECORD = "<record/>";

    public AbstractSftpIterator(String baseUrl, int port, String username, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.port = port;
        this.username = username;
        this.isRecursive = isRecursive;
        this.extensionsSet = extensionsSet;
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = LocalDate.parse(fromDate, this.simpleDateTimeFormatter);
            log.debug("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString());
        }
        try {
            URI sftpServer = new URI(baseUrl);
            this.sftpURIScheme = sftpServer.getScheme();
            this.sftpServerAddress = sftpServer.getHost();
            this.remoteSftpBasePath = sftpServer.getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad syntax in the URL " + baseUrl);
        }
    }

    protected void connectToSftpServer() {
        try {
            this.sftpSession = this.createSession(this.sftpServerAddress, this.port, this.username);
            this.sftpSession.connect();
            log.debug("SFTP session connected");
            Channel channel = this.sftpSession.openChannel(this.sftpURIScheme);
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
            String pwd = this.sftpChannel.pwd();
            log.debug("PWD from server: " + pwd);
            String fullPath = pwd + this.remoteSftpBasePath;
            this.sftpChannel.cd(fullPath);
            log.debug("PWD from server 2 after 'cd " + fullPath + "' : " + this.sftpChannel.pwd());
            log.info("Connected to SFTP server " + this.sftpServerAddress);
        }
        catch (JSchException e) {
            log.error("Unable to connect to remote SFTP server.", (Throwable)e);
            throw new RuntimeException("Unable to connect to remote SFTP server.", e);
        }
        catch (SftpException e) {
            log.error("Unable to access the base remote path on the SFTP server.", (Throwable)e);
            throw new RuntimeException("Unable to access the base remote path on the SFTP server.", e);
        }
    }

    protected abstract Session createSession(String var1, int var2, String var3) throws JSchException;

    protected void disconnectFromSftpServer() {
        this.sftpChannel.exit();
        this.sftpSession.disconnect();
    }

    protected void initializeQueue() {
        this.queue = new LinkedList<String>();
        log.info(String.format("SFTP collector plugin collecting from %s with recursion = %s, incremental = %s with fromDate=%s", this.remoteSftpBasePath, this.isRecursive, this.incremental, this.fromDate));
        this.listDirectoryRecursive(".", "");
    }

    private void listDirectoryRecursive(String parentDir, String currentDir) {
        Object dirToList = parentDir;
        if (StringUtils.isNotBlank((CharSequence)currentDir)) {
            dirToList = (String)dirToList + "/" + currentDir;
        }
        log.debug("PARENT DIR: " + parentDir);
        log.debug("DIR TO LIST: " + (String)dirToList);
        try {
            for (Object o : this.sftpChannel.ls((String)dirToList)) {
                ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)o;
                Object currentFileName = entry.getFilename();
                if (".".equals(currentFileName) || "..".equals(currentFileName)) continue;
                SftpATTRS attrs = entry.getAttrs();
                if (attrs.isDir()) {
                    if (!this.isRecursive) continue;
                    this.listDirectoryRecursive((String)dirToList, (String)currentFileName);
                    continue;
                }
                for (String ext : this.extensionsSet) {
                    if (!((String)currentFileName).endsWith(ext)) continue;
                    if (((String)dirToList).length() > 2) {
                        currentFileName = (String)dirToList + "/" + (String)currentFileName;
                    }
                    if (this.incremental) {
                        int mTime = attrs.getMTime();
                        LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochMilli((long)mTime * 1000L), TimeZone.getDefault().toZoneId());
                        if (dt.isAfter(this.fromDate.atStartOfDay())) {
                            this.queue.add((String)currentFileName);
                            log.debug((String)currentFileName + " has changed and must be re-collected");
                            continue;
                        }
                        if (!log.isDebugEnabled()) continue;
                        log.debug((String)currentFileName + " has not changed since last collection");
                        continue;
                    }
                    this.queue.add((String)currentFileName);
                }
            }
        }
        catch (SftpException e) {
            throw new RuntimeException("Cannot list the sftp remote directory", e);
        }
    }

    @Override
    public boolean hasNext() {
        if (this.queue.isEmpty()) {
            this.disconnectFromSftpServer();
            return false;
        }
        return true;
    }

    @Override
    public String next() {
        String nextRemotePath = this.queue.remove();
        int nRepeat = 0;
        Object fullPathFile = nextRemotePath;
        while (nRepeat < 5) {
            try {
                String doc;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.sftpChannel.get(nextRemotePath, (OutputStream)baos);
                if (log.isDebugEnabled()) {
                    fullPathFile = this.sftpChannel.pwd() + "/" + nextRemotePath;
                    log.debug(String.format("Collected file from SFTP: %s%s", this.sftpServerAddress, fullPathFile));
                }
                if (StringUtils.isNotBlank((CharSequence)(doc = baos.toString()))) {
                    return doc;
                }
                return EMPTY_RECORD;
            }
            catch (SftpException e) {
                log.warn(String.format("An error occurred [%s] for %s%s, retrying.. [retried %s time(s)]", e.getMessage(), this.sftpServerAddress, fullPathFile, ++nRepeat));
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e1) {
                    log.error(e1.getMessage(), (Throwable)e1);
                }
            }
        }
        throw new RuntimeException(String.format("Impossible to retrieve FTP file %s after %s retries. Aborting FTP collection.", fullPathFile, nRepeat));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

