/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.zenodo;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Iterator;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class ZenodoTarIterator
implements Iterator<String>,
Closeable {
    private final InputStream gzipInputStream;
    private final StringBuilder currentItem = new StringBuilder();
    private TarArchiveInputStream tais;
    private boolean hasNext;

    public ZenodoTarIterator(InputStream gzipInputStream) {
        this.gzipInputStream = gzipInputStream;
        this.tais = new TarArchiveInputStream(gzipInputStream);
        this.hasNext = this.getNextItem();
    }

    private boolean getNextItem() {
        try {
            TarArchiveEntry entry;
            while ((entry = this.tais.getNextTarEntry()) != null) {
                if (!entry.isFile()) continue;
                this.currentItem.setLength(0);
                this.currentItem.append(IOUtils.toString((Reader)new InputStreamReader((InputStream)this.tais)));
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public String next() {
        String data = this.currentItem.toString();
        this.hasNext = this.getNextItem();
        return data;
    }

    @Override
    public void close() throws IOException {
        this.gzipInputStream.close();
    }
}

