/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$AuthorPID$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$EBILinks$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$GzFileIterator$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkCreatePubmedDump;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser2;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.sx.bio.pubmed.PubMedToOaf$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JString;
import org.json4s.JValue;
import org.json4s.JsonAST$;
import org.json4s.MonadicJValue$;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.LoggerFactory;
import scala.;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0005\rUe\u0001B.]\u0001\u001dDQA\u001c\u0001\u0005\u0002=DqA\u001d\u0001C\u0002\u0013\u00051\u000fC\u0004\u0002\u0002\u0001\u0001\u000b\u0011\u0002;\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u00191\u0011Q\u0006\u0001\u0001\u0003_A!\"a\u0018\u0006\u0005\u0003\u0005\u000b\u0011BA1\u0011\u0019qW\u0001\"\u0001\u0002r!9\u0011\u0011P\u0003\u0005B\u0005m\u0004bBAB\u000b\u0011\u0005\u0013QQ\u0004\b\u0003#\u0003\u0001\u0012AAJ\r\u001d\t)\n\u0001E\u0001\u0003/CaA\\\u0006\u0005\u0002\u0005e\u0005bBAN\u0017\u0011\u0005\u0011Q\u0014\u0005\b\u0003[\u0003A\u0011AA\u0003\u0011\u001d\t9\f\u0001C\u0001\u0003s3a!!2\u0001\u0001\u0006\u001d\u0007BCAk!\tU\r\u0011\"\u0001\u0002X\"Q\u0011\u0011\u001c\t\u0003\u0012\u0003\u0006I!a\u0014\t\u0015\u0005m\u0007C!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0002^B\u0011\t\u0012)A\u0005\u0003\u001fBaA\u001c\t\u0005\u0002\u0005}\u0007\"CAt!\u0005\u0005I\u0011AAu\u0011%\ty\u000fEI\u0001\n\u0003\t\t\u0010C\u0005\u0003\bA\t\n\u0011\"\u0001\u0002r\"I!\u0011\u0002\t\u0002\u0002\u0013\u0005#1\u0002\u0005\n\u0005\u001b\u0001\u0012\u0011!C\u0001\u0005\u001fA\u0011Ba\u0006\u0011\u0003\u0003%\tA!\u0007\t\u0013\t\u0015\u0002#!A\u0005B\t\u001d\u0002\"\u0003B\u001a!\u0005\u0005I\u0011\u0001B\u001b\u0011%\u0011I\u0004EA\u0001\n\u0003\u0012Y\u0004C\u0005\u0003@A\t\t\u0011\"\u0011\u0003B!I!1\t\t\u0002\u0002\u0013\u0005\u0013Q\u0011\u0005\n\u0005\u000b\u0002\u0012\u0011!C!\u0005\u000f:\u0011Ba\u0013\u0001\u0003\u0003E\tA!\u0014\u0007\u0013\u0005\u0015\u0007!!A\t\u0002\t=\u0003B\u00028$\t\u0003\u0011\t\u0007C\u0005\u0003D\r\n\t\u0011\"\u0012\u0002\u0006\"I\u00111T\u0012\u0002\u0002\u0013\u0005%1\r\u0005\n\u0005S\u001a\u0013\u0011!CA\u0005WBqA! \u0001\t\u0003\u0011y\bC\u0004\u0003\u0006\u0002!\t!!\u0002\t\u000f\t%\u0005\u0001\"\u0001\u0002\u0006!9!Q\u0012\u0001\u0005\u0002\u0005\u0015\u0001b\u0002BI\u0001\u0011%!1\u0013\u0005\b\u0005K\u0003A\u0011AA\u0003\u0011\u001d\u0011I\u000b\u0001C\u0005\u0005WCqA!1\u0001\t\u0003\t)\u0001C\u0004\u0003D\u0002!\t!!\u0002\t\u000f\t\u001d\u0007\u0001\"\u0001\u0002\u0006!9!1\u001a\u0001\u0005\u0002\u0005\u0015\u0001b\u0002Bh\u0001\u0011\u0005\u0011Q\u0001\u0004\u0007\u0005'\u0004\u0001I!6\t\u0015\t]GG!f\u0001\n\u0003\t9\u000e\u0003\u0006\u0003ZR\u0012\t\u0012)A\u0005\u0003\u001fB!Ba75\u0005+\u0007I\u0011AAl\u0011)\u0011i\u000e\u000eB\tB\u0003%\u0011q\n\u0005\u000b\u0005?$$Q3A\u0005\u0002\u0005]\u0007B\u0003Bqi\tE\t\u0015!\u0003\u0002P!Q!1\u001d\u001b\u0003\u0016\u0004%\t!a6\t\u0015\t\u0015HG!E!\u0002\u0013\ty\u0005\u0003\u0006\u0003hR\u0012)\u001a!C\u0001\u0003/D!B!;5\u0005#\u0005\u000b\u0011BA(\u0011)\u0011Y\u000f\u000eBK\u0002\u0013\u0005\u0011q\u001b\u0005\u000b\u0005[$$\u0011#Q\u0001\n\u0005=\u0003B\u000285\t\u0003\u0011y\u000fC\u0005\u0002hR\n\t\u0011\"\u0001\u0003\u0000\"I\u0011q\u001e\u001b\u0012\u0002\u0013\u0005\u0011\u0011\u001f\u0005\n\u0005\u000f!\u0014\u0013!C\u0001\u0003cD\u0011b!\u00045#\u0003%\t!!=\t\u0013\r=A'%A\u0005\u0002\u0005E\b\"CB\tiE\u0005I\u0011AAy\u0011%\u0019\u0019\u0002NI\u0001\n\u0003\t\t\u0010C\u0005\u0003\nQ\n\t\u0011\"\u0011\u0003\f!I!Q\u0002\u001b\u0002\u0002\u0013\u0005!q\u0002\u0005\n\u0005/!\u0014\u0011!C\u0001\u0007+A\u0011B!\n5\u0003\u0003%\tEa\n\t\u0013\tMB'!A\u0005\u0002\re\u0001\"\u0003B\u001di\u0005\u0005I\u0011IB\u000f\u0011%\u0011y\u0004NA\u0001\n\u0003\u0012\t\u0005C\u0005\u0003DQ\n\t\u0011\"\u0011\u0002\u0006\"I!Q\t\u001b\u0002\u0002\u0013\u00053\u0011E\u0004\n\u0007K\u0001\u0011\u0011!E\u0001\u0007O1\u0011Ba5\u0001\u0003\u0003E\ta!\u000b\t\r9\u001cF\u0011AB\u0019\u0011%\u0011\u0019eUA\u0001\n\u000b\n)\tC\u0005\u0002\u001cN\u000b\t\u0011\"!\u00044!I!\u0011N*\u0002\u0002\u0013\u00055\u0011\t\u0005\b\u0007\u001b\u0002A\u0011AB(\u0011\u001d\u00199\u0006\u0001C\u0001\u0003\u000bAAba\u0017\u0001!\u0003\u0005\t\u0011!C\u0001\u0007;\u0012aBQ5p'\u000eDw\u000e\\5y)\u0016\u001cHO\u0003\u0002^=\u0006\u0019!-[8\u000b\u0005}\u0003\u0017AA:y\u0015\t\t'-A\u0002eQBT!a\u00193\u0002\u000f\u0011tW\r\u001e7jE*\tQ-\u0001\u0002fk\u000e\u00011C\u0001\u0001i!\tIG.D\u0001k\u0015\tY\u0007-A\u0006bO\u001e\u0014XmZ1uS>t\u0017BA7k\u0005Y\t%m\u001d;sC\u000e$hk\\2bEVd\u0017M]=UKN$\u0018A\u0002\u001fj]&$h\bF\u0001q!\t\t\b!D\u0001]\u0003\u0019i\u0017\r\u001d9feV\tA\u000f\u0005\u0002v}6\taO\u0003\u0002xq\u0006AA-\u0019;bE&tGM\u0003\u0002zu\u00069!.Y2lg>t'BA>}\u0003%1\u0017m\u001d;feblGNC\u0001~\u0003\r\u0019w.\\\u0005\u0003\u007fZ\u0014Ab\u00142kK\u000e$X*\u00199qKJ\fq!\\1qa\u0016\u0014\b%A\u0003tKR,\u0006\u000f\u0006\u0002\u0002\bA!\u0011\u0011BA\b\u001b\t\tYA\u0003\u0002\u0002\u000e\u0005)1oY1mC&!\u0011\u0011CA\u0006\u0005\u0011)f.\u001b;)\u0007\u0011\t)\u0002\u0005\u0003\u0002\u0018\u0005%RBAA\r\u0015\u0011\tY\"!\b\u0002\u0007\u0005\u0004\u0018N\u0003\u0003\u0002 \u0005\u0005\u0012a\u00026va&$XM\u001d\u0006\u0005\u0003G\t)#A\u0003kk:LGO\u0003\u0002\u0002(\u0005\u0019qN]4\n\t\u0005-\u0012\u0011\u0004\u0002\u000b\u0005\u00164wN]3FC\u000eD'A\u0006\"vM\u001a,'/\u001a3SK\u0006$WM]%uKJ\fGo\u001c:\u0014\u000b\u0015\t\t$a\u000e\u0011\t\u0005%\u00111G\u0005\u0005\u0003k\tYA\u0001\u0004B]f\u0014VM\u001a\t\u0007\u0003s\tI%a\u0014\u000f\t\u0005m\u0012Q\t\b\u0005\u0003{\t\u0019%\u0004\u0002\u0002@)\u0019\u0011\u0011\t4\u0002\rq\u0012xn\u001c;?\u0013\t\ti!\u0003\u0003\u0002H\u0005-\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003\u0017\niE\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\u0011\t9%a\u0003\u0011\t\u0005E\u0013\u0011\f\b\u0005\u0003'\n)\u0006\u0005\u0003\u0002>\u0005-\u0011\u0002BA,\u0003\u0017\ta\u0001\u0015:fI\u00164\u0017\u0002BA.\u0003;\u0012aa\u0015;sS:<'\u0002BA,\u0003\u0017\taA]3bI\u0016\u0014\b\u0003BA2\u0003[j!!!\u001a\u000b\t\u0005\u001d\u0014\u0011N\u0001\u0003S>T!!a\u001b\u0002\t)\fg/Y\u0005\u0005\u0003_\n)G\u0001\bCk\u001a4WM]3e%\u0016\fG-\u001a:\u0015\t\u0005M\u0014q\u000f\t\u0004\u0003k*Q\"\u0001\u0001\t\u000f\u0005}s\u00011\u0001\u0002b\u00059\u0001.Y:OKb$HCAA?!\u0011\tI!a \n\t\u0005\u0005\u00151\u0002\u0002\b\u0005>|G.Z1o\u0003\u0011qW\r\u001f;\u0015\u0005\u0005\u001d\u0005\u0003BAE\u0003\u001fk!!a#\u000b\t\u00055\u0015\u0011N\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\\\u0005-\u0015AD${\r&dW-\u0013;fe\u0006$xN\u001d\t\u0004\u0003kZ!AD${\r&dW-\u0013;fe\u0006$xN]\n\u0004\u0017\u0005EBCAAJ\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\u0019(a(\u0002*\"9\u0011\u0011U\u0007A\u0002\u0005\r\u0016AA5t!\u0011\t\u0019'!*\n\t\u0005\u001d\u0016Q\r\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002,6\u0001\r!a\u0014\u0002\u0011\u0015t7m\u001c3j]\u001e\fq\u0001^3tiBKG\rK\u0002\u000f\u0003c\u0003B!a\u0006\u00024&!\u0011QWA\r\u0005\u0011!Vm\u001d;\u0002%\u0015DHO]1di\u00063g-\u001b7jCRLwN\u001c\u000b\u0005\u0003w\u000b\t\r\u0005\u0004\u0002:\u0005u\u0016qJ\u0005\u0005\u0003\u007f\u000biE\u0001\u0003MSN$\bbBAb\u001f\u0001\u0007\u0011qJ\u0001\u0002g\nI\u0011)\u001e;i_J\u0004\u0016\nR\n\b!\u0005E\u0012\u0011ZAh!\u0011\tI!a3\n\t\u00055\u00171\u0002\u0002\b!J|G-^2u!\u0011\tI$!5\n\t\u0005M\u0017Q\n\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\ba&$G+\u001f9f+\t\ty%\u0001\u0005qS\u0012$\u0016\u0010]3!\u0003\r\u0001\u0018\u000eZ\u0001\u0005a&$\u0007\u0005\u0006\u0004\u0002b\u0006\r\u0018Q\u001d\t\u0004\u0003k\u0002\u0002bBAk+\u0001\u0007\u0011q\n\u0005\b\u00037,\u0002\u0019AA(\u0003\u0011\u0019w\u000e]=\u0015\r\u0005\u0005\u00181^Aw\u0011%\t)N\u0006I\u0001\u0002\u0004\ty\u0005C\u0005\u0002\\Z\u0001\n\u00111\u0001\u0002P\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAAzU\u0011\ty%!>,\u0005\u0005]\b\u0003BA}\u0005\u0007i!!a?\u000b\t\u0005u\u0018q`\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!\u0001\u0002\f\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\u00111 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0015\u0001\u00049s_\u0012,8\r^!sSRLXC\u0001B\t!\u0011\tIAa\u0005\n\t\tU\u00111\u0002\u0002\u0004\u0013:$\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u00057\u0011\t\u0003\u0005\u0003\u0002\n\tu\u0011\u0002\u0002B\u0010\u0003\u0017\u00111!\u00118z\u0011%\u0011\u0019cGA\u0001\u0002\u0004\u0011\t\"A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005S\u0001bAa\u000b\u00032\tmQB\u0001B\u0017\u0015\u0011\u0011y#a\u0003\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002L\t5\u0012\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005u$q\u0007\u0005\n\u0005Gi\u0012\u0011!a\u0001\u00057\t!\u0003\u001d:pIV\u001cG/\u00127f[\u0016tGOT1nKR!\u0011q\u0011B\u001f\u0011%\u0011\u0019CHA\u0001\u0002\u0004\u0011\t\"\u0001\u0005iCND7i\u001c3f)\t\u0011\t\"\u0001\u0005u_N#(/\u001b8h\u0003\u0019)\u0017/^1mgR!\u0011Q\u0010B%\u0011%\u0011\u0019#IA\u0001\u0002\u0004\u0011Y\"A\u0005BkRDwN\u001d)J\tB\u0019\u0011QO\u0012\u0014\u000b\r\u0012\tF!\u0018\u0011\u0015\tM#\u0011LA(\u0003\u001f\n\t/\u0004\u0002\u0003V)!!qKA\u0006\u0003\u001d\u0011XO\u001c;j[\u0016LAAa\u0017\u0003V\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0011\t\u0005\r$qL\u0005\u0005\u0003'\f)\u0007\u0006\u0002\u0003NQ1\u0011\u0011\u001dB3\u0005OBq!!6'\u0001\u0004\ty\u0005C\u0004\u0002\\\u001a\u0002\r!a\u0014\u0002\u000fUt\u0017\r\u001d9msR!!Q\u000eB=!\u0019\tIAa\u001c\u0003t%!!\u0011OA\u0006\u0005\u0019y\u0005\u000f^5p]BA\u0011\u0011\u0002B;\u0003\u001f\ny%\u0003\u0003\u0003x\u0005-!A\u0002+va2,'\u0007C\u0005\u0003|\u001d\n\t\u00111\u0001\u0002b\u0006\u0019\u0001\u0010\n\u0019\u0002/\u0015DHO]1di\u0006+H\u000f[8s\u0013\u0012,g\u000e^5gS\u0016\u0014H\u0003\u0002BA\u0005\u0007\u0003b!!\u000f\u0002>\u0006\u0005\bbBAbQ\u0001\u0007\u0011qJ\u0001\u0013i\u0016\u001cH\u000fU1sg&tw\rU;c[\u0016$'\u0007K\u0002*\u0003c\u000b1\u0002^3ti\u0016\u0013\u0015\nR1uC\"\u001a!&!-\u0002\u001fQ,7\u000f\u001e)vE6,G\rV8PC\u001aD3aKAY\u00039\u0019\u0007.Z2l!6\u000b%\u000f^5dY\u0016$B!a\u0002\u0003\u0016\"9!q\u0013\u0017A\u0002\te\u0015aB1si&\u001cG.\u001a\t\u0005\u00057\u0013\t+\u0004\u0002\u0003\u001e*\u0019!q\u0014/\u0002\rA,(-\\3e\u0013\u0011\u0011\u0019K!(\u0003\u0013Ak\u0015I\u001d;jG2,\u0017\u0001\u0006;fgR\u0004\u0016M]:j]\u001e\u0004VOY7fIbkE\nK\u0002.\u0003c\u000bac\u00195fG.\u0004VOY7fIB+(\r\\5dCRLwN\u001c\u000b\u0005\u0003\u000f\u0011i\u000bC\u0004\u00030:\u0002\rA!-\u0002\u0003=\u0004BAa-\u0003>6\u0011!Q\u0017\u0006\u0005\u0005o\u0013I,A\u0002pC\u001aT1Aa/a\u0003\u0019\u00198\r[3nC&!!q\u0018B[\u0005\ry\u0015MZ\u0001\u0014i\u0016\u001cH\u000fU;c[\u0016$7\u000b\u001d7jiRLgnZ\u0001\u0015i\u0016\u001cH\u000fU;c[\u0016$wJ]5hS:\fG.\u0013#)\u0007A\n\t,A\tuKN$\b+\u001e2nK\u0012l\u0015\r\u001d9j]\u001eD3!MAY\u00031!Xm\u001d;Q\t\n#vnT!GQ\r\u0011\u0014\u0011W\u0001\u0011i\u0016\u001cH/\u0016(JaJ|G\u000fV8P\u0003\u001aC3aMAY\u0005!)%)\u0013'j].\u001c8c\u0002\u001b\u00022\u0005%\u0017qZ\u0001\be\u0016dG+\u001f9f\u0003!\u0011X\r\u001c+za\u0016\u0004\u0013\u0001\u00023bi\u0016\fQ\u0001Z1uK\u0002\nQ\u0001^5uY\u0016\fa\u0001^5uY\u0016\u0004\u0013\u0001\u00029nS\u0012\fQ\u0001]7jI\u0002\n\u0011\u0002^1sO\u0016$\b+\u001b3\u0002\u0015Q\f'oZ3u!&$\u0007%A\u0007uCJ<W\r\u001e)jIRK\b/Z\u0001\u000fi\u0006\u0014x-\u001a;QS\u0012$\u0016\u0010]3!)9\u0011\tPa=\u0003v\n](\u0011 B~\u0005{\u00042!!\u001e5\u0011\u001d\u00119.\u0011a\u0001\u0003\u001fBqAa7B\u0001\u0004\ty\u0005C\u0004\u0003`\u0006\u0003\r!a\u0014\t\u000f\t\r\u0018\t1\u0001\u0002P!9!q]!A\u0002\u0005=\u0003b\u0002Bv\u0003\u0002\u0007\u0011q\n\u000b\u000f\u0005c\u001c\taa\u0001\u0004\u0006\r\u001d1\u0011BB\u0006\u0011%\u00119N\u0011I\u0001\u0002\u0004\ty\u0005C\u0005\u0003\\\n\u0003\n\u00111\u0001\u0002P!I!q\u001c\"\u0011\u0002\u0003\u0007\u0011q\n\u0005\n\u0005G\u0014\u0005\u0013!a\u0001\u0003\u001fB\u0011Ba:C!\u0003\u0005\r!a\u0014\t\u0013\t-(\t%AA\u0002\u0005=\u0013AD2paf$C-\u001a4bk2$HeM\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIU\nabY8qs\u0012\"WMZ1vYR$c\u0007\u0006\u0003\u0003\u001c\r]\u0001\"\u0003B\u0012\u0017\u0006\u0005\t\u0019\u0001B\t)\u0011\tiha\u0007\t\u0013\t\rR*!AA\u0002\tmA\u0003BAD\u0007?A\u0011Ba\tO\u0003\u0003\u0005\rA!\u0005\u0015\t\u0005u41\u0005\u0005\n\u0005G\t\u0016\u0011!a\u0001\u00057\t\u0001\"\u0012\"J\u0019&t7n\u001d\t\u0004\u0003k\u001a6#B*\u0004,\tu\u0003C\u0005B*\u0007[\ty%a\u0014\u0002P\u0005=\u0013qJA(\u0005cLAaa\f\u0003V\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001c\u0015\u0005\r\u001dBC\u0004By\u0007k\u00199d!\u000f\u0004<\ru2q\b\u0005\b\u0005/4\u0006\u0019AA(\u0011\u001d\u0011YN\u0016a\u0001\u0003\u001fBqAa8W\u0001\u0004\ty\u0005C\u0004\u0003dZ\u0003\r!a\u0014\t\u000f\t\u001dh\u000b1\u0001\u0002P!9!1\u001e,A\u0002\u0005=C\u0003BB\"\u0007\u0017\u0002b!!\u0003\u0003p\r\u0015\u0003\u0003EA\u0005\u0007\u000f\ny%a\u0014\u0002P\u0005=\u0013qJA(\u0013\u0011\u0019I%a\u0003\u0003\rQ+\b\u000f\\37\u0011%\u0011YhVA\u0001\u0002\u0004\u0011\t0A\bqCJ\u001cXmX3cS~c\u0017N\\6t)\u0011\u0019\tfa\u0015\u0011\r\u0005e\u0012Q\u0018By\u0011\u001d\u0019)\u0006\u0017a\u0001\u0003\u001f\nQ!\u001b8qkR\f\u0011\u0003^3ti\u0016\u0013\u0015\nT5oWN$vnT!GQ\rI\u0016\u0011W\u0001\u0017aJ|G/Z2uK\u0012$co\\2bEVd\u0017M]5fgR!1qLB8!\u0011\u0019\tga\u001b\u000e\u0005\r\r$\u0002BB3\u0007O\n!B^8dC\n,H.\u0019:z\u0015\r\u0019I\u0007Y\u0001\u0007G>lWn\u001c8\n\t\r541\r\u0002\u0010->\u001c\u0017MY;mCJLxI]8va\"A!1\u0005.\u0002\u0002\u0003\u0007\u0001\u000fK\u0004\u0001\u0007g\u001ayh!!\u0011\t\rU41P\u0007\u0003\u0007oRAa!\u001f\u0002\u001a\u0005IQ\r\u001f;f]NLwN\\\u0005\u0005\u0007{\u001a9H\u0001\u0006FqR,g\u000eZ,ji\"\fQA^1mk\u0016d#aa!$\u0005\r\u0015\u0005\u0003BBD\u0007#k!a!#\u000b\t\u0005}11\u0012\u0006\u0005\u0003G\u0019iI\u0003\u0003\u0004\u0010\u0006\u0015\u0012aB7pG.LGo\\\u0005\u0005\u0007'\u001bII\u0001\tN_\u000e\\\u0017\u000e^8FqR,gn]5p]\u0002")
public class BioScholixTest
extends AbstractVocabularyTest {
    private volatile BioScholixTest$GzFileIterator$ GzFileIterator$module;
    private volatile BioScholixTest$AuthorPID$ AuthorPID$module;
    private volatile BioScholixTest$EBILinks$ EBILinks$module;
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);

    public BioScholixTest$GzFileIterator$ GzFileIterator() {
        if (this.GzFileIterator$module == null) {
            this.GzFileIterator$lzycompute$1();
        }
        return this.GzFileIterator$module;
    }

    public BioScholixTest$AuthorPID$ AuthorPID() {
        if (this.AuthorPID$module == null) {
            this.AuthorPID$lzycompute$1();
        }
        return this.AuthorPID$module;
    }

    public BioScholixTest$EBILinks$ EBILinks() {
        if (this.EBILinks$module == null) {
            this.EBILinks$lzycompute$1();
        }
        return this.EBILinks$module;
    }

    public /* synthetic */ VocabularyGroup protected$vocabularies(BioScholixTest x$1) {
        return x$1.vocabularies;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void testPid() {
        List pids = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"0000000163025705", "000000018494732X", "0000000308873343", "0000000335964515", "0000000333457333", "0000000335964515", "0000000302921949", "http://orcid.org/0000-0001-8567-3543", "http://orcid.org/0000-0001-7868-8528", "0000-0001-9189-1440", "0000-0003-3727-9247", "0000-0001-7246-1058", "000000033962389X", "0000000330371470", "0000000171236123", "0000000272569752", "0000000293231371", "http://orcid.org/0000-0003-3345-7333", "0000000340145688", "http://orcid.org/0000-0003-4894-1689"}));
        pids.foreach((Function1 & Serializable)pid -> {
            BioScholixTest.$anonfun$testPid$1(pid);
            return BoxedUnit.UNIT;
        });
    }

    public List<String> extractAffiliation(String s) {
        String regex = "<Affiliation>(.*)<\\/Affiliation>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)matcher.group(1));
        }
        return l.toList();
    }

    public List<AuthorPID> extractAuthorIdentifier(String s) {
        String regex = "<Identifier Source=\"(.*)\">(.*)<\\/Identifier>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)new AuthorPID(this, matcher.group(1), matcher.group(2)));
        }
        return l.toList();
    }

    @Test
    public void testParsingPubmed2() {
        ObjectMapper mapper = new ObjectMapper();
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/single_pubmed.xml"));
        PMParser2 parser = new PMParser2();
        PMArticle article = parser.parse(xml);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)PubMedToOaf$.MODULE$.convert(article, this.vocabularies)));
    }

    @Test
    public void testEBIData() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        new PMParser(xml).foreach((Function1 & Serializable)s -> {
            Predef$.MODULE$.println((Object)this.mapper().writeValueAsString((Object)s));
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPubmedToOaf() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List r = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().map((Function1 & Serializable)s -> (PMArticle)this.mapper().readValue(s, PMArticle.class)).map((Function1 & Serializable)a -> PubMedToOaf$.MODULE$.convert(a, this.protected$vocabularies(this)));
        Assertions.assertEquals((int)10, (int)r.size());
        Assertions.assertTrue((boolean)r.map((Function1 & Serializable)p -> (Result)p).flatMap((Function1 & Serializable)p -> (Buffer)((IterableOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).map((Function1 & Serializable)i -> i.getInstancetype().getClassid())).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPubmedToOaf$7(p))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(r.head()));
    }

    private void checkPMArticle(PMArticle article) {
        Assertions.assertNotNull((Object)article.getPmid());
        Assertions.assertNotNull((Object)article.getTitle());
        Assertions.assertNotNull((Object)article.getAuthors());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).foreach((Function1 & Serializable)a -> {
            BioScholixTest.$anonfun$checkPMArticle$1(a);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testParsingPubmedXML() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        parser.foreach((Function1 & Serializable)article -> {
            this.checkPMArticle(article);
            return BoxedUnit.UNIT;
        });
    }

    private void checkPubmedPublication(Oaf o) {
        Assertions.assertTrue((boolean)(o instanceof Publication));
        Publication p = (Publication)o;
        Assertions.assertNotNull((Object)p.getId());
        Assertions.assertNotNull((Object)p.getTitle());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getTitle()).asScala()).foreach((Function1 & Serializable)t -> {
            BioScholixTest.$anonfun$checkPubmedPublication$1(t);
            return BoxedUnit.UNIT;
        });
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthor()).asScala()).foreach((Function1 & Serializable)a -> {
            BioScholixTest.$anonfun$checkPubmedPublication$2(a);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getInstance());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).foreach((Function1 & Serializable)i -> {
            BioScholixTest.$anonfun$checkPubmedPublication$3(i);
            return BoxedUnit.UNIT;
        });
        Assertions.assertNotNull((Object)p.getOriginalId());
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).foreach((Function1 & Serializable)oId -> {
            BioScholixTest.$anonfun$checkPubmedPublication$4(oId);
            return BoxedUnit.UNIT;
        });
        boolean hasPMC = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).exists((Function1 & Serializable)i -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$5(i)));
        if (hasPMC) {
            Assertions.assertTrue((boolean)((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).exists((Function1 & Serializable)oId -> BoxesRunTime.boxToBoolean((boolean)oId.startsWith("od_______267::"))));
            return;
        }
    }

    public void testPubmedSplitting() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("test").master("local").getOrCreate();
        new SparkCreatePubmedDump("", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), LoggerFactory.getLogger(this.getClass())).createPubmedDump(spark, "/home/sandro/Downloads/pubmed", "/home/sandro/Downloads/pubmed_mapped", this.vocabularies);
    }

    @Test
    public void testPubmedOriginalID() {
        PMArticle article = new PMArticle();
        article.setPmid("1234");
        article.setTitle("a Title");
        article.getPublicationTypes().add(new PMSubject("article", null, null));
        Publication publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        article.setPmcId("PMC1517292");
        publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        String oldOpenaireID = "od_______267::0000072375bc0e68fa09d4e6b7658248";
        boolean hasOldOpenAIREID = ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getOriginalId()).asScala()).exists((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)o.equalsIgnoreCase(oldOpenaireID)));
        Assertions.assertTrue((boolean)hasOldOpenAIREID);
    }

    @Test
    public void testPubmedMapping() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach((Function1 & Serializable)x -> (ListBuffer)results.$plus$eq((Object)PubMedToOaf$.MODULE$.convert(x, this.protected$vocabularies(this))));
        results.foreach((Function1 & Serializable)o -> {
            this.checkPubmedPublication(o);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPDBToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pdb_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$testPDBToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().flatMap((Function1 & Serializable)o -> BioDBToOAF$.MODULE$.pdbTOOaf(o, this.protected$vocabularies(this)));
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable)r -> {
            BioScholixTest.$anonfun$testPDBToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testPDBToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testUNIprotToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/uniprot_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).foreach((Function1 & Serializable)s -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$2(s);
            return BoxedUnit.UNIT;
        });
        List result = StringOps$.MODULE$.linesWithSeparators$extension(Predef$.MODULE$.augmentString(records)).map((Function1 & Serializable)l -> StringOps$.MODULE$.stripLineEnd$extension(Predef$.MODULE$.augmentString(l))).toList().flatMap((Function1 & Serializable)o -> BioDBToOAF$.MODULE$.uniprotToOAF(o, this.protected$vocabularies(this)));
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1 & Serializable)r -> {
            BioScholixTest.$anonfun$testUNIprotToOAF$5(r);
            return BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1 & Serializable)o -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$testUNIprotToOAF$6(o)))));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    public List<EBILinks> parse_ebi_links(String input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String pmid = (String)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)), "publication")), "pmid")), (Formats)BioScholixTest.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        return MonadicJValue$.MODULE$.withFilter$extension(org.json4s.package$.MODULE$.jvalue2monadic(MonadicJValue$.MODULE$.$bslash$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(BioScholixTest.json$1(json$lzy, input)), "Link")), (Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$1(check$ifrefutable$1))).flatMap((Function1 & Serializable)x$9 -> {
            JValue jValue = x$9;
            if (jValue instanceof JObject) {
                JObject jObject = (JObject)jValue;
                List link = jObject.obj();
                return (List)link.withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$3(check$ifrefutable$2))).flatMap((Function1 & Serializable)x$8 -> {
                    Tuple2 tuple2;
                    Tuple2 tuple22 = x$8;
                    if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                        String string = (String)tuple2._1();
                        JValue jValue = (JValue)tuple2._2();
                        if ("Target".equals(string) && jValue instanceof JObject) {
                            JObject jObject = (JObject)jValue;
                            List target = jObject.obj();
                            return (IterableOnce)link.withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$5(check$ifrefutable$3))).flatMap((Function1 & Serializable)x$7 -> {
                                Tuple2 tuple2;
                                Tuple2 tuple22 = x$7;
                                if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                    String string = (String)tuple2._1();
                                    JValue jValue = (JValue)tuple2._2();
                                    if ("RelationshipType".equals(string) && jValue instanceof JObject) {
                                        JObject jObject = (JObject)jValue;
                                        List relType = jObject.obj();
                                        return (IterableOnce)relType.withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$7(check$ifrefutable$4))).flatMap((Function1 & Serializable)x$6 -> {
                                            Tuple2 tuple2;
                                            Tuple2 tuple22 = x$6;
                                            if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                String string = (String)tuple2._1();
                                                JValue jValue = (JValue)tuple2._2();
                                                if ("Name".equals(string) && jValue instanceof JString) {
                                                    JString jString = (JString)jValue;
                                                    String relation = jString.s();
                                                    return (IterableOnce)link.withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$9(check$ifrefutable$5))).flatMap((Function1 & Serializable)x$5 -> {
                                                        Tuple2 tuple2;
                                                        Tuple2 tuple22 = x$5;
                                                        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                            String string = (String)tuple2._1();
                                                            JValue jValue = (JValue)tuple2._2();
                                                            if ("PublicationDate".equals(string) && jValue instanceof JString) {
                                                                JString jString = (JString)jValue;
                                                                String publicationDate = jString.s();
                                                                return (IterableOnce)target.withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$11(check$ifrefutable$6))).flatMap((Function1 & Serializable)x$4 -> {
                                                                    Tuple2 tuple2;
                                                                    Tuple2 tuple22 = x$4;
                                                                    if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                        String string = (String)tuple2._1();
                                                                        JValue jValue = (JValue)tuple2._2();
                                                                        if ("Title".equals(string) && jValue instanceof JString) {
                                                                            JString jString = (JString)jValue;
                                                                            String title = jString.s();
                                                                            return (IterableOnce)target.withFilter((Function1 & Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$13(check$ifrefutable$7))).flatMap((Function1 & Serializable)x$3 -> {
                                                                                Tuple2 tuple2;
                                                                                Tuple2 tuple22 = x$3;
                                                                                if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                    String string = (String)tuple2._1();
                                                                                    JValue jValue = (JValue)tuple2._2();
                                                                                    if ("Identifier".equals(string) && jValue instanceof JObject) {
                                                                                        JObject jObject = (JObject)jValue;
                                                                                        List identifier = jObject.obj();
                                                                                        return (IterableOnce)identifier.withFilter((Function1 & Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$15(check$ifrefutable$8))).flatMap((Function1 & Serializable)x$2 -> {
                                                                                            Tuple2 tuple2;
                                                                                            Tuple2 tuple22 = x$2;
                                                                                            if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                                String string = (String)tuple2._1();
                                                                                                JValue jValue = (JValue)tuple2._2();
                                                                                                if ("IDScheme".equals(string) && jValue instanceof JString) {
                                                                                                    JString jString = (JString)jValue;
                                                                                                    String idScheme = jString.s();
                                                                                                    return (IterableOnce)identifier.withFilter((Function1 & Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$parse_ebi_links$17(check$ifrefutable$9))).map((Function1 & Serializable)x$1 -> {
                                                                                                        Tuple2 tuple2;
                                                                                                        Tuple2 tuple22 = x$1;
                                                                                                        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
                                                                                                            String string = (String)tuple2._1();
                                                                                                            JValue jValue = (JValue)tuple2._2();
                                                                                                            if ("ID".equals(string) && jValue instanceof JString) {
                                                                                                                JString jString = (JString)jValue;
                                                                                                                String id = jString.s();
                                                                                                                return new EBILinks(this, relation, publicationDate, title, pmid, id, idScheme);
                                                                                                            }
                                                                                                        }
                                                                                                        throw new MatchError((Object)tuple22);
                                                                                                    });
                                                                                                }
                                                                                            }
                                                                                            throw new MatchError((Object)tuple22);
                                                                                        });
                                                                                    }
                                                                                }
                                                                                throw new MatchError((Object)tuple22);
                                                                            });
                                                                        }
                                                                    }
                                                                    throw new MatchError((Object)tuple22);
                                                                });
                                                            }
                                                        }
                                                        throw new MatchError((Object)tuple22);
                                                    });
                                                }
                                            }
                                            throw new MatchError((Object)tuple22);
                                        });
                                    }
                                }
                                throw new MatchError((Object)tuple22);
                            });
                        }
                    }
                    throw new MatchError((Object)tuple22);
                });
            }
            throw new MatchError((Object)jValue);
        });
    }

    @Test
    public void testEBILinksToOAF() {
        BufferedReaderIterator iterator = this.GzFileIterator().apply(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/ebi_links.gz"), "UTF-8");
        String data = iterator.next();
        List res = BioDBToOAF$.MODULE$.parse_ebi_links(BioDBToOAF$.MODULE$.extractEBILinksFromDump(data).links()).filter((Function1 & Serializable)input -> BoxesRunTime.boxToBoolean((boolean)BioDBToOAF$.MODULE$.EBITargetLinksFilter(input))).flatMap((Function1 & Serializable)input -> BioDBToOAF$.MODULE$.convertEBILinksToOaf(input));
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)res.length()));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(res.head()));
    }

    private final void GzFileIterator$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.GzFileIterator$module == null) {
                this.GzFileIterator$module = new BioScholixTest$GzFileIterator$(this);
            }
        }
    }

    private final void AuthorPID$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.AuthorPID$module == null) {
                this.AuthorPID$module = new BioScholixTest$AuthorPID$(this);
            }
        }
    }

    private final void EBILinks$lzycompute$1() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.EBILinks$module == null) {
                this.EBILinks$module = new BioScholixTest$EBILinks$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$testPid$1(String pid) {
        String pidCleaned = new PMIdentifier(pid, "ORCID").getPid();
        Predef$.MODULE$.println((Object)pidCleaned);
        Assertions.assertTrue((boolean)pidCleaned.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]"));
    }

    public static final /* synthetic */ boolean $anonfun$testPubmedToOaf$7(String p) {
        return "0037".equalsIgnoreCase(p);
    }

    public static final /* synthetic */ void $anonfun$checkPMArticle$1(PMAuthor a) {
        Assertions.assertNotNull((Object)a);
        Assertions.assertNotNull((Object)a.getFullName());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$1(StructuredProperty t) {
        Assertions.assertNotNull((Object)t.getValue());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$2(Author a) {
        Assertions.assertNotNull((Object)a.getFullname());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$3(Instance i) {
        Assertions.assertNotNull((Object)i.getCollectedfrom());
        Assertions.assertNotNull((Object)i.getPid());
        Assertions.assertNotNull((Object)i.getInstancetype());
    }

    public static final /* synthetic */ void $anonfun$checkPubmedPublication$4(String oId) {
        Assertions.assertNotNull((Object)oId);
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$6(StructuredProperty pid) {
        return pid.getQualifier().getClassid().equalsIgnoreCase(PidType.pmc.toString());
    }

    public static final /* synthetic */ boolean $anonfun$checkPubmedPublication$5(Instance i) {
        return ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).exists((Function1 & Serializable)pid -> BoxesRunTime.boxToBoolean((boolean)BioScholixTest.$anonfun$checkPubmedPublication$6(pid)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    public static final /* synthetic */ void $anonfun$testPDBToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testPDBToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$2(String s) {
        Assertions.assertTrue((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s)));
    }

    public static final /* synthetic */ void $anonfun$testUNIprotToOAF$5(Oaf r) {
        Assertions.assertNotNull((Object)r);
    }

    public static final /* synthetic */ boolean $anonfun$testUNIprotToOAF$6(Oaf o) {
        return o instanceof Relation;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return BioScholixTest.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JValue json$lzycompute$1(LazyRef json$lzy$1, String input$1) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JValue)json$lzy$1.value() : (JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse((Object)input$1, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$1(LazyRef json$lzy$1, String input$1) {
        if (json$lzy$1.initialized()) {
            return (JValue)json$lzy$1.value();
        }
        return BioScholixTest.json$lzycompute$1(json$lzy$1, input$1);
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$1(JValue check$ifrefutable$1) {
        JValue jValue = check$ifrefutable$1;
        return jValue instanceof JObject;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$2;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Target".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$5(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$3;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("RelationshipType".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$7(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$4;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Name".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$9(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$5;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("PublicationDate".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$11(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$6;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Title".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$13(Tuple2 check$ifrefutable$7) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$7;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("Identifier".equals(string) && jValue instanceof JObject) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$15(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$8;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("IDScheme".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$parse_ebi_links$17(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2;
        Tuple2 tuple22 = check$ifrefutable$9;
        if (tuple22 != null && !SomeValue$.MODULE$.isEmpty$extension((Object)(tuple2 = JsonAST$.MODULE$.JField().unapply(tuple22)))) {
            String string = (String)tuple2._1();
            JValue jValue = (JValue)tuple2._2();
            if ("ID".equals(string) && jValue instanceof JString) {
                return true;
            }
        }
        return false;
    }

    public BioScholixTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public class AuthorPID
    implements Product,
    Serializable {
        private final String pidType;
        private final String pid;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String pidType() {
            return this.pidType;
        }

        public String pid() {
            return this.pid;
        }

        public AuthorPID copy(String pidType, String pid) {
            return new AuthorPID(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer(), pidType, pid);
        }

        public String copy$default$1() {
            return this.pidType();
        }

        public String copy$default$2() {
            return this.pid();
        }

        public String productPrefix() {
            return "AuthorPID";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.pidType();
                }
                case 1: {
                    return this.pid();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthorPID;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "pidType";
                }
                case 1: {
                    return "pid";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthorPID)) return false;
            if (((AuthorPID)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthorPID authorPID = (AuthorPID)x$1;
            String string = this.pidType();
            String string2 = authorPID.pidType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pid();
            String string4 = authorPID.pid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!authorPID.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() {
            return this.$outer;
        }

        public AuthorPID(BioScholixTest $outer, String pidType, String pid) {
            this.pidType = pidType;
            this.pid = pid;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }

    public class BufferedReaderIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        public final /* synthetic */ BioScholixTest $outer;

        public final boolean hasDefiniteSize() {
            return Iterator.hasDefiniteSize$((Iterator)this);
        }

        public final Iterator<String> iterator() {
            return Iterator.iterator$((Iterator)this);
        }

        public Option<String> nextOption() {
            return Iterator.nextOption$((Iterator)this);
        }

        public boolean contains(Object elem) {
            return Iterator.contains$((Iterator)this, (Object)elem);
        }

        public BufferedIterator<String> buffered() {
            return Iterator.buffered$((Iterator)this);
        }

        public <B> Iterator<B> padTo(int len, B elem) {
            return Iterator.padTo$((Iterator)this, (int)len, elem);
        }

        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
            return Iterator.partition$((Iterator)this, p);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.grouped$((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.sliding$((Iterator)this, (int)size, (int)step);
        }

        public <B> int sliding$default$2() {
            return Iterator.sliding$default$2$((Iterator)this);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
            return Iterator.scanLeft$((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
            return Iterator.scanRight$((Iterator)this, z, op);
        }

        public int indexWhere(Function1<String, Object> p, int from) {
            return Iterator.indexWhere$((Iterator)this, p, (int)from);
        }

        public int indexWhere$default$2() {
            return Iterator.indexWhere$default$2$((Iterator)this);
        }

        public <B> int indexOf(B elem) {
            return Iterator.indexOf$((Iterator)this, elem);
        }

        public <B> int indexOf(B elem, int from) {
            return Iterator.indexOf$((Iterator)this, elem, (int)from);
        }

        public final int length() {
            return Iterator.length$((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.isEmpty$((Iterator)this);
        }

        public Iterator<String> filter(Function1<String, Object> p) {
            return Iterator.filter$((Iterator)this, p);
        }

        public Iterator<String> filterNot(Function1<String, Object> p) {
            return Iterator.filterNot$((Iterator)this, p);
        }

        public Iterator<String> filterImpl(Function1<String, Object> p, boolean isFlipped) {
            return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
        }

        public Iterator<String> withFilter(Function1<String, Object> p) {
            return Iterator.withFilter$((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
            return Iterator.collect$((Iterator)this, pf);
        }

        public Iterator<String> distinct() {
            return Iterator.distinct$((Iterator)this);
        }

        public <B> Iterator<String> distinctBy(Function1<String, B> f) {
            return Iterator.distinctBy$((Iterator)this, f);
        }

        public <B> Iterator<B> map(Function1<String, B> f) {
            return Iterator.map$((Iterator)this, f);
        }

        public <B> Iterator<B> flatMap(Function1<String, IterableOnce<B>> f) {
            return Iterator.flatMap$((Iterator)this, f);
        }

        public <B> Iterator<B> flatten(Function1<String, IterableOnce<B>> ev) {
            return Iterator.flatten$((Iterator)this, ev);
        }

        public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
            return Iterator.concat$((Iterator)this, xs);
        }

        public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
            return Iterator.$plus$plus$((Iterator)this, xs);
        }

        public Iterator<String> take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        public Iterator<String> takeWhile(Function1<String, Object> p) {
            return Iterator.takeWhile$((Iterator)this, p);
        }

        public Iterator<String> drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        public Iterator<String> dropWhile(Function1<String, Object> p) {
            return Iterator.dropWhile$((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
            return Iterator.span$((Iterator)this, p);
        }

        public Iterator<String> slice(int from, int until) {
            return Iterator.slice$((Iterator)this, (int)from, (int)until);
        }

        public Iterator<String> sliceIterator(int from, int until) {
            return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<Tuple2<String, B>> zip(IterableOnce<B> that) {
            return Iterator.zip$((Iterator)this, that);
        }

        public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
            return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
        }

        public Iterator<Tuple2<String, Object>> zipWithIndex() {
            return Iterator.zipWithIndex$((Iterator)this);
        }

        public <B> boolean sameElements(IterableOnce<B> that) {
            return Iterator.sameElements$((Iterator)this, that);
        }

        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
            return Iterator.duplicate$((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <U> Iterator<String> tapEach(Function1<String, U> f) {
            return Iterator.tapEach$((Iterator)this, f);
        }

        public String toString() {
            return Iterator.toString$((Iterator)this);
        }

        public Iterator<String> seq() {
            return Iterator.seq$((Iterator)this);
        }

        public Tuple2<Iterator<String>, Iterator<String>> splitAt(int n) {
            return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
        }

        public boolean isTraversableAgain() {
            return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
        }

        public <U> void foreach(Function1<String, U> f) {
            IterableOnceOps.foreach$((IterableOnceOps)this, f);
        }

        public boolean forall(Function1<String, Object> p) {
            return IterableOnceOps.forall$((IterableOnceOps)this, p);
        }

        public boolean exists(Function1<String, Object> p) {
            return IterableOnceOps.exists$((IterableOnceOps)this, p);
        }

        public int count(Function1<String, Object> p) {
            return IterableOnceOps.count$((IterableOnceOps)this, p);
        }

        public Option<String> find(Function1<String, Object> p) {
            return IterableOnceOps.find$((IterableOnceOps)this, p);
        }

        public <B> B foldLeft(B z, Function2<B, String, B> op) {
            return (B)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
        }

        public <B> B foldRight(B z, Function2<String, B, B> op) {
            return (B)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
        }

        public final <B> B $div$colon(B z, Function2<B, String, B> op) {
            return (B)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
        }

        public final <B> B $colon$bslash(B z, Function2<String, B, B> op) {
            return (B)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
        }

        public <B> B reduce(Function2<B, B, B> op) {
            return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceOption(Function2<B, B, B> op) {
            return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
        }

        public <B> B reduceLeft(Function2<B, String, B> op) {
            return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
        }

        public <B> B reduceRight(Function2<String, B, B> op) {
            return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
            return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
            return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
        }

        public boolean nonEmpty() {
            return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
        }

        public int size() {
            return IterableOnceOps.size$((IterableOnceOps)this);
        }

        public final <B> void copyToBuffer(Buffer<B> dest) {
            IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
        }

        public <B> int copyToArray(Object xs) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
        }

        public <B> int copyToArray(Object xs, int start) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
        }

        public <B> int copyToArray(Object xs, int start, int len) {
            return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
        }

        public Object min(Ordering ord) {
            return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<String> minOption(Ordering<B> ord) {
            return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
        }

        public Object max(Ordering ord) {
            return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
        }

        public <B> Option<String> maxOption(Ordering<B> ord) {
            return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
        }

        public Object maxBy(Function1 f, Ordering ord) {
            return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
        }

        public <B> Option<String> maxByOption(Function1<String, B> f, Ordering<B> ord) {
            return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
        }

        public Object minBy(Function1 f, Ordering ord) {
            return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
        }

        public <B> Option<String> minByOption(Function1<String, B> f, Ordering<B> ord) {
            return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
        }

        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
            return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
            return (B)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
        }

        public <B> boolean corresponds(IterableOnce<B> that, Function2<String, B, Object> p) {
            return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
        }

        public final String mkString(String start, String sep, String end) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
        }

        public final String mkString(String sep) {
            return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
        }

        public final String mkString() {
            return IterableOnceOps.mkString$((IterableOnceOps)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public final StringBuilder addString(StringBuilder b, String sep) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
        }

        public final StringBuilder addString(StringBuilder b) {
            return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
        }

        public <C1> C1 to(Factory<String, C1> factory) {
            return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
        }

        public final Iterator<String> toIterator() {
            return IterableOnceOps.toIterator$((IterableOnceOps)this);
        }

        public List<String> toList() {
            return IterableOnceOps.toList$((IterableOnceOps)this);
        }

        public Vector<String> toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        public <K, V> Map<K, V> toMap(.less.colon.less<String, Tuple2<K, V>> ev) {
            return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
        }

        public <B> Set<B> toSet() {
            return IterableOnceOps.toSet$((IterableOnceOps)this);
        }

        public Seq<String> toSeq() {
            return IterableOnceOps.toSeq$((IterableOnceOps)this);
        }

        public IndexedSeq<String> toIndexedSeq() {
            return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
        }

        public final Stream<String> toStream() {
            return IterableOnceOps.toStream$((IterableOnceOps)this);
        }

        public final <B> Buffer<B> toBuffer() {
            return IterableOnceOps.toBuffer$((IterableOnceOps)this);
        }

        public <B> Object toArray(ClassTag<B> evidence$2) {
            return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
        }

        public Iterable<String> reversed() {
            return IterableOnceOps.reversed$((IterableOnceOps)this);
        }

        public <S extends Stepper<?>> S stepper(StepperShape<String, S> shape) {
            return (S)IterableOnce.stepper$((IterableOnce)this, shape);
        }

        public int knownSize() {
            return IterableOnce.knownSize$((IterableOnce)this);
        }

        public boolean hasNext() {
            return this.reader.ready();
        }

        public String next() {
            return this.reader.readLine();
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$BufferedReaderIterator$$$outer() {
            return this.$outer;
        }

        public BufferedReaderIterator(BioScholixTest $outer, BufferedReader reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
        }
    }

    public class EBILinks
    implements Product,
    Serializable {
        private final String relType;
        private final String date;
        private final String title;
        private final String pmid;
        private final String targetPid;
        private final String targetPidType;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String relType() {
            return this.relType;
        }

        public String date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public String pmid() {
            return this.pmid;
        }

        public String targetPid() {
            return this.targetPid;
        }

        public String targetPidType() {
            return this.targetPidType;
        }

        public EBILinks copy(String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            return new EBILinks(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer(), relType, date, title, pmid, targetPid, targetPidType);
        }

        public String copy$default$1() {
            return this.relType();
        }

        public String copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public String copy$default$4() {
            return this.pmid();
        }

        public String copy$default$5() {
            return this.targetPid();
        }

        public String copy$default$6() {
            return this.targetPidType();
        }

        public String productPrefix() {
            return "EBILinks";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return this.relType();
                }
                case 1: {
                    return this.date();
                }
                case 2: {
                    return this.title();
                }
                case 3: {
                    return this.pmid();
                }
                case 4: {
                    return this.targetPid();
                }
                case 5: {
                    return this.targetPidType();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EBILinks;
        }

        public String productElementName(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    return "relType";
                }
                case 1: {
                    return "date";
                }
                case 2: {
                    return "title";
                }
                case 3: {
                    return "pmid";
                }
                case 4: {
                    return "targetPid";
                }
                case 5: {
                    return "targetPidType";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EBILinks)) return false;
            if (((EBILinks)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EBILinks eBILinks = (EBILinks)x$1;
            String string = this.relType();
            String string2 = eBILinks.relType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.date();
            String string4 = eBILinks.date();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.title();
            String string6 = eBILinks.title();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.pmid();
            String string8 = eBILinks.pmid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.targetPid();
            String string10 = eBILinks.targetPid();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.targetPidType();
            String string12 = eBILinks.targetPidType();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            if (!eBILinks.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() {
            return this.$outer;
        }

        public EBILinks(BioScholixTest $outer, String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            this.relType = relType;
            this.date = date;
            this.title = title;
            this.pmid = pmid;
            this.targetPid = targetPid;
            this.targetPidType = targetPidType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

