/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation.xslt;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import eu.dnetlib.dhp.transformation.xslt.utils.Capitalize;
import eu.dnetlib.dhp.transformation.xslt.utils.DotAbbreviations;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.sf.saxon.s9api.ExtensionFunction;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.OccurrenceIndicator;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.SequenceType;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmValue;

public class PersonCleaner
implements ExtensionFunction,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> firstname = Lists.newArrayList();
    private List<String> surname = Lists.newArrayList();
    private List<String> fullname = Lists.newArrayList();
    private static final Set<String> particles = null;

    private String normalize(String s) {
        s = Normalizer.normalize(s, Normalizer.Form.NFD);
        s = s.replaceAll("\\(.+\\)", "");
        s = s.replaceAll("\\[.+\\]", "");
        s = s.replaceAll("\\{.+\\}", "");
        s = s.replaceAll("\\s+-\\s+", "-");
        s = s.replaceAll("[\\p{Punct}&&[^-,]]", " ");
        s = s.replace("\\d", " ");
        s = s.replace("\\n", " ");
        s = s.replace("\\.", " ");
        if ((s = s.replaceAll("\\s+", " ")).contains(",")) {
            String[] arr = s.split(",");
            if (arr.length == 1) {
                this.fullname = this.splitTerms(arr[0]);
            } else if (arr.length > 1) {
                this.surname = this.splitTerms(arr[0]);
                this.firstname = this.splitTermsFirstName(arr[1]);
                this.fullname.addAll(this.surname);
                this.fullname.addAll(this.firstname);
            }
        } else {
            this.fullname = this.splitTerms(s);
            int lastInitialPosition = this.fullname.size();
            boolean hasSurnameInUpperCase = false;
            for (int i = 0; i < this.fullname.size(); ++i) {
                String term = this.fullname.get(i);
                if (term.length() == 1) {
                    lastInitialPosition = i;
                    continue;
                }
                if (!term.equals(term.toUpperCase())) continue;
                hasSurnameInUpperCase = true;
            }
            if (lastInitialPosition < this.fullname.size() - 1) {
                this.firstname = this.fullname.subList(0, lastInitialPosition + 1);
                this.surname = this.fullname.subList(lastInitialPosition + 1, this.fullname.size());
            } else if (hasSurnameInUpperCase) {
                for (String term : this.fullname) {
                    if (term.length() > 1 && term.equals(term.toUpperCase())) {
                        this.surname.add(term);
                        continue;
                    }
                    this.firstname.add(term);
                }
            } else if (lastInitialPosition == this.fullname.size()) {
                this.surname = this.fullname.subList(lastInitialPosition - 1, this.fullname.size());
                this.firstname = this.fullname.subList(0, lastInitialPosition - 1);
            }
        }
        return null;
    }

    private List<String> splitTermsFirstName(String s) {
        ArrayList list = Lists.newArrayList();
        for (String part : Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)s)) {
            if (s.trim().matches("\\p{Lu}{2,3}")) {
                String[] parts;
                for (String p : parts = s.trim().split("(?=\\p{Lu})")) {
                    if (p.length() <= 0) continue;
                    list.add(p);
                }
                continue;
            }
            list.add(part);
        }
        return list;
    }

    private List<String> splitTerms(String s) {
        ArrayList list = Lists.newArrayList();
        for (String part : Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)s)) {
            list.add(part);
        }
        return list;
    }

    public List<String> getFirstname() {
        return this.firstname;
    }

    public List<String> getSurname() {
        return this.surname;
    }

    public List<String> getFullname() {
        return this.fullname;
    }

    public String hash() {
        return Hashing.murmur3_128().hashString((CharSequence)this.getNormalisedFullname(), StandardCharsets.UTF_8).toString();
    }

    public String getNormalisedFullname() {
        return this.isAccurate() ? Joiner.on((String)" ").join(this.getSurname()) + ", " + Joiner.on((String)" ").join(this.getNameWithAbbreviations()) : Joiner.on((String)" ").join(this.fullname);
    }

    public List<String> getCapitalSurname() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.surname, (Function)new Capitalize()));
    }

    public List<String> getNameWithAbbreviations() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.firstname, (Function)new DotAbbreviations()));
    }

    public boolean isAccurate() {
        return this.firstname != null && this.surname != null && !this.firstname.isEmpty() && !this.surname.isEmpty();
    }

    public QName getName() {
        return new QName("http://eu/dnetlib/transform/person", "normalize");
    }

    public SequenceType getResultType() {
        return SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_ONE);
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.makeSequenceType((ItemType)ItemType.STRING, (OccurrenceIndicator)OccurrenceIndicator.ZERO_OR_ONE)};
    }

    public XdmValue call(XdmValue[] xdmValues) throws SaxonApiException {
        XdmValue r = xdmValues[0];
        if (r.size() == 0) {
            return new XdmAtomicValue("");
        }
        String currentValue = xdmValues[0].itemAt(0).getStringValue();
        return new XdmAtomicValue(this.normalize(currentValue));
    }
}

