/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.PrepareProgramme;
import eu.dnetlib.dhp.actionmanager.project.utils.model.CSVProgramme;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareH2020ProgrammeTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ClassLoader cl = PrepareH2020ProgrammeTest.class.getClassLoader();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareH2020ProgrammeTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareH2020ProgrammeTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareH2020ProgrammeTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void numberDistinctProgrammeTest() throws Exception {
        PrepareProgramme.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-programmePath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/h2020_programme.json.gz").getPath(), "-outputPath", workingDir.toString() + "/preparedProgramme"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/preparedProgramme").map((Function & Serializable)item -> (CSVProgramme)OBJECT_MAPPER.readValue(item, CSVProgramme.class));
        Assertions.assertEquals((long)279L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(CSVProgramme.class));
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("title =''").count());
        Assertions.assertEquals((long)0L, (long)verificationDataset.filter("classification = ''").count());
        Assertions.assertEquals((Object)"Societal challenges | Smart, Green And Integrated Transport | CLEANSKY2 | IADP Fast Rotorcraft", (Object)((Row)verificationDataset.filter("code = 'H2020-EU.3.4.5.3.'").select("classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Euratom | Indirect actions | European Fusion Development Agreement", (Object)((Row)verificationDataset.filter("code = 'H2020-Euratom-1.9.'").select("classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Industrial leadership | Leadership in enabling and industrial technologies | Advanced manufacturing and processing | New sustainable business models", (Object)((Row)verificationDataset.filter("code = 'H2020-EU.2.1.5.4.'").select("classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Excellent science | Future and Emerging Technologies (FET) | FET Open", (Object)((Row)verificationDataset.filter("code = 'H2020-EU.1.2.1.'").select("classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Industrial leadership | Leadership in enabling and industrial technologies | Biotechnology", (Object)((Row)verificationDataset.filter("code = 'H2020-EU.2.1.4.'").select("classification", new String[0]).collectAsList().get(0)).getString(0));
    }

    static {
        log = LoggerFactory.getLogger(PrepareH2020ProgrammeTest.class);
    }
}

