/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.base;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.base.BaseCollectorIterator;
import eu.dnetlib.dhp.collection.plugin.file.AbstractSplittedRecordPlugin;
import eu.dnetlib.dhp.common.DbClient;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseCollectorPlugin
implements CollectorPlugin {
    private final FileSystem fs;
    private static final Logger log = LoggerFactory.getLogger(AbstractSplittedRecordPlugin.class);

    public BaseCollectorPlugin(FileSystem fs) {
        this.fs = fs;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        Path filePath = Optional.ofNullable(api.getBaseUrl()).map(Path::new).orElseThrow(() -> new CollectorException("missing baseUrl"));
        String dbUrl = (String)api.getParams().get("dbUrl");
        String dbUser = (String)api.getParams().get("dbUser");
        String dbPassword = (String)api.getParams().get("dbPassword");
        String acceptedNormTypesString = (String)api.getParams().get("acceptedNormTypes");
        log.info("baseUrl: {}", (Object)filePath);
        log.info("dbUrl: {}", (Object)dbUrl);
        log.info("dbUser: {}", (Object)dbUser);
        log.info("dbPassword: {}", (Object)"***");
        log.info("acceptedNormTypes: {}", (Object)acceptedNormTypesString);
        try {
            if (!this.fs.exists(filePath)) {
                throw new CollectorException("path does not exist: " + String.valueOf(filePath));
            }
        }
        catch (Throwable e) {
            throw new CollectorException(e);
        }
        Set<String> acceptedOpendoarIds = this.findAcceptedOpendoarIds(dbUrl, dbUser, dbPassword);
        HashSet<String> acceptedNormTypes = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)acceptedNormTypesString)) {
            for (String s : StringUtils.split((String)acceptedNormTypesString, (String)",")) {
                if (!StringUtils.isNotBlank((CharSequence)s)) continue;
                acceptedNormTypes.add(s.trim());
            }
        }
        BaseCollectorIterator iterator = new BaseCollectorIterator(this.fs, filePath, report);
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return StreamSupport.stream(spliterator, false).filter(doc -> BaseCollectorPlugin.filterXml(doc, acceptedOpendoarIds, acceptedNormTypes));
    }

    private Set<String> findAcceptedOpendoarIds(String dbUrl, String dbUser, String dbPassword) throws CollectorException {
        HashSet<String> accepted = new HashSet<String>();
        try (DbClient dbClient = new DbClient(dbUrl, dbUser, dbPassword);){
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/plugin/base/sql/opendoar-accepted.sql"));
            dbClient.processResults(sql, row -> {
                try {
                    String dsId = row.getString("id");
                    log.info("Accepted Datasource: " + dsId);
                    accepted.add(dsId);
                }
                catch (SQLException e) {
                    log.error("Error in SQL", (Throwable)e);
                    throw new RuntimeException("Error in SQL", e);
                }
            });
        }
        catch (IOException e) {
            log.error("Error accessong SQL", (Throwable)e);
            throw new CollectorException("Error accessong SQL", (Throwable)e);
        }
        log.info("Accepted Datasources (TOTAL): " + accepted.size());
        return accepted;
    }

    protected static boolean filterXml(String xml, Set<String> acceptedOpendoarIds, Set<String> acceptedNormTypes) {
        try {
            Document doc = DocumentHelper.parseText((String)xml);
            String id = doc.valueOf("//*[local-name()='collection']/@opendoar_id").trim();
            if (StringUtils.isBlank((CharSequence)id) || !acceptedOpendoarIds.contains("opendoar____::" + id)) {
                return false;
            }
            if (acceptedNormTypes.isEmpty()) {
                return true;
            }
            for (Object s : doc.selectNodes("//*[local-name()='typenorm']")) {
                if (!acceptedNormTypes.contains(((Node)s).getText().trim())) continue;
                return true;
            }
            return false;
        }
        catch (DocumentException e) {
            log.error("Error parsing document", (Throwable)e);
            throw new RuntimeException("Error parsing document", e);
        }
    }
}

