/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.ProjectSubset;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.DbClient;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class ReadProjectsFromDB
implements Closeable {
    private static final Log log = LogFactory.getLog(ReadProjectsFromDB.class);
    private static final String query = "SELECT code  from projects where id like 'corda__h2020%' ";
    private final DbClient dbClient;
    private final Configuration conf;
    private final BufferedWriter writer;
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ReadProjectsFromDB.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/project/read_projects_db.json")));
        parser.parseArgument(args);
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        String hdfsPath = parser.get("hdfsPath");
        String hdfsNameNode = parser.get("hdfsNameNode");
        try (ReadProjectsFromDB rbl = new ReadProjectsFromDB(hdfsPath, hdfsNameNode, dbUrl, dbUser, dbPassword);){
            log.info((Object)"Processing projects...");
            rbl.execute(query, rbl::processProjectsEntry);
        }
    }

    public void execute(String sql, Function<ResultSet, List<ProjectSubset>> producer) {
        Consumer<ResultSet> consumer = rs -> ((List)producer.apply((ResultSet)rs)).forEach(this::writeProject);
        this.dbClient.processResults(sql, consumer);
    }

    public List<ProjectSubset> processProjectsEntry(ResultSet rs) {
        try {
            ProjectSubset p = new ProjectSubset();
            p.setCode(rs.getString("code"));
            return Arrays.asList(p);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void writeProject(ProjectSubset r) {
        try {
            this.writer.write(this.OBJECT_MAPPER.writeValueAsString((Object)r));
            this.writer.newLine();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public ReadProjectsFromDB(String hdfsPath, String hdfsNameNode, String dbUrl, String dbUser, String dbPassword) throws IOException {
        this.dbClient = new DbClient(dbUrl, dbUser, dbPassword);
        this.conf = new Configuration();
        this.conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fileSystem = FileSystem.get((Configuration)this.conf);
        Path hdfsWritePath = new Path(hdfsPath);
        if (fileSystem.exists(hdfsWritePath)) {
            fileSystem.delete(hdfsWritePath, false);
        }
        FSDataOutputStream fos = fileSystem.create(hdfsWritePath);
        this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8));
    }

    @Override
    public void close() throws IOException {
        this.dbClient.close();
        this.writer.close();
    }
}

