/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.mongodb;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class MongoDbDumpCollectorPlugin
implements CollectorPlugin {
    public static final String PATH_PARAM = "path";
    public static final String BODY_JSONPATH = "$.body";
    private final FileSystem fileSystem;

    public MongoDbDumpCollectorPlugin(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        Path path = Optional.ofNullable((String)api.getParams().get(PATH_PARAM)).map(Path::new).orElseThrow(() -> new CollectorException(String.format("missing parameter '%s'", PATH_PARAM)));
        try {
            if (!this.fileSystem.exists(path)) {
                throw new CollectorException("path does not exist: " + path.toString());
            }
            return new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream((InputStream)this.fileSystem.open(path)), Charset.defaultCharset())).lines().map(s -> DHPUtils.getJPathString((String)BODY_JSONPATH, (String)s));
        }
        catch (IOException e) {
            throw new CollectorException((Throwable)e);
        }
    }
}

