/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.PrepareProjects;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractFromZip
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareProjects.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareProjects.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/project/extract_fromzip_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        String inputPath = parser.get("inputPath");
        log.info("inputPath {}: ", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        String hdfsNameNode = parser.get("hdfsNameNode");
        log.info("hdfsNameNode {}", (Object)hdfsNameNode);
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", hdfsNameNode);
        FileSystem fs = FileSystem.get((Configuration)conf);
        ExtractFromZip.doExtract(inputPath, outputPath, fs);
    }

    private static void doExtract(String inputFile, String workingPath, FileSystem fileSystem) throws IOException {
        Path path = new Path(inputFile);
        FSDataInputStream project_zip = fileSystem.open(path);
        try (ZipInputStream zis = new ZipInputStream((InputStream)project_zip);){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                byte[] buffer = new byte[1024];
                FSDataOutputStream out = fileSystem.create(new Path(workingPath + fileName));
                try {
                    int count;
                    while ((count = zis.read(buffer, 0, buffer.length)) != -1) {
                        out.write(buffer, 0, count);
                    }
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
        }
    }
}

