/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import com.ximpleware.AutoPilot;
import com.ximpleware.ParseException;
import com.ximpleware.VTDGen;
import com.ximpleware.VTDNav;
import eu.dnetlib.dhp.collection.orcid.model.Author;
import eu.dnetlib.dhp.collection.orcid.model.Employment;
import eu.dnetlib.dhp.collection.orcid.model.Pid;
import eu.dnetlib.dhp.collection.orcid.model.Work;
import eu.dnetlib.dhp.parser.utility.VtdUtilityParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrcidParser {
    final Logger log = LoggerFactory.getLogger(OrcidParser.class);
    private VTDNav vn;
    private AutoPilot ap;
    private static final String NS_COMMON_URL = "http://www.orcid.org/ns/common";
    private static final String NS_COMMON = "common";
    private static final String NS_PERSON_URL = "http://www.orcid.org/ns/person";
    private static final String NS_PERSON = "person";
    private static final String NS_DETAILS_URL = "http://www.orcid.org/ns/personal-details";
    private static final String NS_DETAILS = "personal-details";
    private static final String NS_OTHER_URL = "http://www.orcid.org/ns/other-name";
    private static final String NS_OTHER = "other-name";
    private static final String NS_RECORD_URL = "http://www.orcid.org/ns/record";
    private static final String NS_RECORD = "record";
    private static final String NS_ERROR_URL = "http://www.orcid.org/ns/error";
    private static final String NS_ACTIVITIES = "activities";
    private static final String NS_ACTIVITIES_URL = "http://www.orcid.org/ns/activities";
    private static final String NS_WORK = "work";
    private static final String NS_WORK_URL = "http://www.orcid.org/ns/work";
    private static final String NS_ERROR = "error";
    private static final String NS_HISTORY = "history";
    private static final String NS_HISTORY_URL = "http://www.orcid.org/ns/history";
    private static final String NS_EMPLOYMENT = "employment";
    private static final String NS_EMPLOYMENT_URL = "http://www.orcid.org/ns/employment";
    private static final String NS_EXTERNAL = "external-identifier";
    private static final String NS_EXTERNAL_URL = "http://www.orcid.org/ns/external-identifier";

    private void generateParsedDocument(String xml) throws ParseException {
        VTDGen vg = new VTDGen();
        vg.setDoc(xml.getBytes());
        vg.parse(true);
        this.vn = vg.getNav();
        this.ap = new AutoPilot(this.vn);
        this.ap.declareXPathNameSpace(NS_COMMON, NS_COMMON_URL);
        this.ap.declareXPathNameSpace(NS_PERSON, NS_PERSON_URL);
        this.ap.declareXPathNameSpace(NS_DETAILS, NS_DETAILS_URL);
        this.ap.declareXPathNameSpace(NS_OTHER, NS_OTHER_URL);
        this.ap.declareXPathNameSpace(NS_RECORD, NS_RECORD_URL);
        this.ap.declareXPathNameSpace(NS_ERROR, NS_ERROR_URL);
        this.ap.declareXPathNameSpace(NS_HISTORY, NS_HISTORY_URL);
        this.ap.declareXPathNameSpace(NS_WORK, NS_WORK_URL);
        this.ap.declareXPathNameSpace(NS_EXTERNAL, NS_EXTERNAL_URL);
        this.ap.declareXPathNameSpace(NS_ACTIVITIES, NS_ACTIVITIES_URL);
        this.ap.declareXPathNameSpace(NS_EMPLOYMENT, NS_EMPLOYMENT_URL);
    }

    public Author parseSummary(String xml) {
        try {
            Author author = new Author();
            this.generateParsedDocument(xml);
            List recordNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//record:record", Collections.singletonList("path"));
            if (recordNodes.isEmpty()) {
                return null;
            }
            String oid = ((String)((VtdUtilityParser.Node)recordNodes.get(0)).getAttributes().get("path")).substring(1);
            author.setOrcid(oid);
            String ltm = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:last-modified-date");
            author.setLastModifiedDate(ltm);
            List personNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//person:name", Arrays.asList("visibility"));
            String visibility = (String)((VtdUtilityParser.Node)personNodes.get(0)).getAttributes().get("visibility");
            author.setVisibility(visibility);
            String name = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//personal-details:given-names");
            author.setGivenName(name);
            String surnames = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//personal-details:family-name");
            author.setFamilyName(surnames);
            String creditNames = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//personal-details:credit-name");
            author.setCreditName(creditNames);
            String biography = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//person:biography/personal-details:content");
            author.setBiography(biography);
            List otherNames = VtdUtilityParser.getTextValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//other-name:content");
            if (!otherNames.isEmpty()) {
                author.setOtherNames(otherNames);
            }
            this.ap.selectXPath("//external-identifier:external-identifier");
            while (this.ap.evalXPath() != -1) {
                int it;
                Pid pid = new Pid();
                AutoPilot ap1 = new AutoPilot(this.ap.getNav());
                ap1.selectXPath("./common:external-id-type");
                while (ap1.evalXPath() != -1) {
                    it = this.vn.getText();
                    pid.setSchema(this.vn.toNormalizedString(it));
                }
                ap1.selectXPath("./common:external-id-value");
                while (ap1.evalXPath() != -1) {
                    it = this.vn.getText();
                    pid.setValue(this.vn.toNormalizedString(it));
                }
                author.addOtherPid(pid);
            }
            return author;
        }
        catch (Throwable e) {
            this.log.error("Error on parsing {}", (Object)xml);
            this.log.error(e.getMessage());
            return null;
        }
    }

    public List<Work> parseWorks(String xml) {
        try {
            this.generateParsedDocument(xml);
            List workNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//activities:works", Arrays.asList("path", "visibility"));
            if (workNodes.isEmpty()) {
                return null;
            }
            String oid = ((String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("path")).split("/")[1];
            ArrayList<Work> works = new ArrayList<Work>();
            this.ap.selectXPath("//work:work-summary");
            while (this.ap.evalXPath() != -1) {
                Work work = new Work();
                work.setOrcid(oid);
                AutoPilot ap1 = new AutoPilot(this.ap.getNav());
                ap1.selectXPath("./work:title/common:title");
                while (ap1.evalXPath() != -1) {
                    int it = this.vn.getText();
                    work.setTitle(this.vn.toNormalizedString(it));
                }
                ap1.selectXPath(".//common:external-id");
                while (ap1.evalXPath() != -1) {
                    int it;
                    Pid pid = new Pid();
                    AutoPilot ap2 = new AutoPilot(ap1.getNav());
                    ap2.selectXPath("./common:external-id-type");
                    while (ap2.evalXPath() != -1) {
                        it = this.vn.getText();
                        pid.setSchema(this.vn.toNormalizedString(it));
                    }
                    ap2.selectXPath("./common:external-id-value");
                    while (ap2.evalXPath() != -1) {
                        it = this.vn.getText();
                        pid.setValue(this.vn.toNormalizedString(it));
                    }
                    work.addPid(pid);
                }
                works.add(work);
            }
            return works;
        }
        catch (Throwable e) {
            this.log.error("Error on parsing {}", (Object)xml);
            this.log.error(e.getMessage());
            return null;
        }
    }

    public Work parseWork(String xml) {
        try {
            Work work = new Work();
            this.generateParsedDocument(xml);
            List workNodes = VtdUtilityParser.getTextValuesWithAttributes((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//work:work", Arrays.asList("path", "visibility"));
            if (workNodes.isEmpty()) {
                return null;
            }
            String oid = ((String)((VtdUtilityParser.Node)workNodes.get(0)).getAttributes().get("path")).split("/")[1];
            work.setOrcid(oid);
            this.ap.selectXPath("//common:external-id");
            while (this.ap.evalXPath() != -1) {
                int it;
                Pid pid = new Pid();
                AutoPilot ap1 = new AutoPilot(this.ap.getNav());
                ap1.selectXPath("./common:external-id-type");
                while (ap1.evalXPath() != -1) {
                    it = this.vn.getText();
                    pid.setSchema(this.vn.toNormalizedString(it));
                }
                ap1.selectXPath("./common:external-id-value");
                while (ap1.evalXPath() != -1) {
                    it = this.vn.getText();
                    pid.setValue(this.vn.toNormalizedString(it));
                }
                work.addPid(pid);
            }
            work.setTitle(VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//work:title/common:title"));
            return work;
        }
        catch (Throwable e) {
            this.log.error("Error on parsing {}", (Object)xml);
            this.log.error(e.getMessage());
            return null;
        }
    }

    private String extractEmploymentDate(String xpath) throws Exception {
        return this.extractEmploymentDate(xpath, this.ap);
    }

    private String extractEmploymentDate(String xpath, AutoPilot pp) throws Exception {
        pp.selectXPath(xpath);
        StringBuilder sb = new StringBuilder();
        while (pp.evalXPath() != -1) {
            int it;
            AutoPilot ap1 = new AutoPilot(pp.getNav());
            ap1.selectXPath("./common:year");
            while (ap1.evalXPath() != -1) {
                it = this.vn.getText();
                sb.append(this.vn.toNormalizedString(it));
            }
            ap1.selectXPath("./common:month");
            while (ap1.evalXPath() != -1) {
                it = this.vn.getText();
                sb.append("-");
                sb.append(this.vn.toNormalizedString(it));
            }
            ap1.selectXPath("./common:day");
            while (ap1.evalXPath() != -1) {
                it = this.vn.getText();
                sb.append("-");
                sb.append(this.vn.toNormalizedString(it));
            }
        }
        return sb.toString();
    }

    public List<Employment> parseEmployments(String xml) {
        try {
            Map<String, String> nsContext = OrcidParser.getNameSpaceMap();
            DocumentFactory.getInstance().setXPathNamespaceURIs(nsContext);
            Document doc = DocumentHelper.parseText((String)xml);
            String oid = doc.valueOf("//activities:employments/@path");
            if (oid == null || StringUtils.isEmpty((CharSequence)oid)) {
                return null;
            }
            String orcid = oid.split("/")[1];
            List nodes = doc.selectNodes("//employment:employment-summary");
            return nodes.stream().map(n -> {
                String ey;
                Employment e = new Employment();
                e.setOrcid(orcid);
                String depName = n.valueOf(".//common:department-name");
                if (StringUtils.isNotBlank((CharSequence)depName)) {
                    e.setDepartmentName(depName);
                }
                String roleTitle = n.valueOf(".//common:role-title");
                e.setRoleTitle(roleTitle);
                String organizationName = n.valueOf(".//common:organization/common:name");
                if (StringUtils.isEmpty((CharSequence)e.getDepartmentName())) {
                    e.setDepartmentName(organizationName);
                }
                Pid p = new Pid();
                String pid = n.valueOf("./common:organization/common:disambiguated-organization/common:disambiguated-organization-identifier");
                p.setValue(pid);
                String pidType = n.valueOf("./common:organization/common:disambiguated-organization/common:disambiguation-source");
                p.setSchema(pidType);
                e.setAffiliationId(p);
                StringBuilder aDate = new StringBuilder();
                String sy = n.valueOf("./common:start-date/common:year");
                if (StringUtils.isNotBlank((CharSequence)sy)) {
                    aDate.append(sy);
                    String sm = n.valueOf("./common:start-date/common:month");
                    String sd = n.valueOf("./common:start-date/common:day");
                    aDate.append("-");
                    if (StringUtils.isNotBlank((CharSequence)sm)) {
                        aDate.append(sm);
                    } else {
                        aDate.append("01");
                    }
                    aDate.append("-");
                    if (StringUtils.isNotBlank((CharSequence)sd)) {
                        aDate.append(sd);
                    } else {
                        aDate.append("01");
                    }
                    e.setEndDate(aDate.toString());
                }
                if (StringUtils.isNotBlank((CharSequence)(ey = n.valueOf("./common:end-date/common:year")))) {
                    aDate.append(ey);
                    String em = n.valueOf("./common:end-date/common:month");
                    String ed = n.valueOf("./common:end-date/common:day");
                    aDate.append("-");
                    if (StringUtils.isNotBlank((CharSequence)em)) {
                        aDate.append(em);
                    } else {
                        aDate.append("01");
                    }
                    aDate.append("-");
                    if (StringUtils.isNotBlank((CharSequence)ed)) {
                        aDate.append(ed);
                    } else {
                        aDate.append("01");
                    }
                    e.setEndDate(aDate.toString());
                }
                return e;
            }).collect(Collectors.toList());
        }
        catch (Throwable e) {
            this.log.error("Error on parsing {}", (Object)xml);
            this.log.error(e.getMessage());
            return null;
        }
    }

    @NotNull
    private static Map<String, String> getNameSpaceMap() {
        HashMap<String, String> nsContext = new HashMap<String, String>();
        nsContext.put(NS_COMMON, NS_COMMON_URL);
        nsContext.put(NS_PERSON, NS_PERSON_URL);
        nsContext.put(NS_DETAILS, NS_DETAILS_URL);
        nsContext.put(NS_OTHER, NS_OTHER_URL);
        nsContext.put(NS_RECORD, NS_RECORD_URL);
        nsContext.put(NS_ERROR, NS_ERROR_URL);
        nsContext.put(NS_HISTORY, NS_HISTORY_URL);
        nsContext.put(NS_WORK, NS_WORK_URL);
        nsContext.put(NS_EXTERNAL, NS_EXTERNAL_URL);
        nsContext.put(NS_ACTIVITIES, NS_ACTIVITIES_URL);
        nsContext.put(NS_EMPLOYMENT, NS_EMPLOYMENT_URL);
        return nsContext;
    }

    public Employment parseEmployment(String xml) {
        try {
            Employment employment = new Employment();
            this.generateParsedDocument(xml);
            String oid = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:source-orcid/common:path");
            if (!StringUtils.isNotBlank((CharSequence)oid)) {
                return null;
            }
            employment.setOrcid(oid);
            String depName = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:department-name");
            String rolTitle = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:role-title");
            if (StringUtils.isNotBlank((CharSequence)rolTitle)) {
                employment.setRoleTitle(rolTitle);
            }
            if (StringUtils.isNotBlank((CharSequence)depName)) {
                employment.setDepartmentName(depName);
            } else {
                employment.setDepartmentName(VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:organization/common:name"));
            }
            employment.setStartDate(this.extractEmploymentDate("//common:start-date"));
            employment.setEndDate(this.extractEmploymentDate("//common:end-date"));
            String affiliationId = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:disambiguated-organization-identifier");
            String affiliationIdType = VtdUtilityParser.getSingleValue((AutoPilot)this.ap, (VTDNav)this.vn, (String)"//common:disambiguation-source");
            if (StringUtils.isNotBlank((CharSequence)affiliationId) || StringUtils.isNotBlank((CharSequence)affiliationIdType)) {
                employment.setAffiliationId(new Pid(affiliationId, affiliationIdType));
            }
            return employment;
        }
        catch (Throwable e) {
            this.log.error("Error on parsing {}", (Object)xml);
            this.log.error(e.getMessage());
            return null;
        }
    }
}

