/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.sftp;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import eu.dnetlib.dhp.collection.plugin.sftp.AbstractSftpIterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftpIteratorWithAuthenticationKey
extends AbstractSftpIterator {
    private static final Logger log = LoggerFactory.getLogger(SftpIteratorWithAuthenticationKey.class);
    private final String privateKeyPath;

    public SftpIteratorWithAuthenticationKey(String baseUrl, int port, String username, boolean isRecursive, Set<String> extensionsSet, String fromDate, String privateKeyPath) {
        super(baseUrl, port, username, isRecursive, extensionsSet, fromDate);
        this.privateKeyPath = privateKeyPath;
        this.init();
    }

    @Override
    protected Session createSession(String address, int port, String username) throws JSchException {
        log.debug("Authenticating with private key");
        JSch jsch = new JSch();
        JSch.setConfig((String)"StrictHostKeyChecking", (String)"no");
        jsch.addIdentity(this.privateKeyPath);
        return jsch.getSession(username, address, port);
    }
}

