/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.orcid.OrcidParser;
import eu.dnetlib.dhp.collection.orcid.model.Author;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadORCIDTest {
    private final Logger log = LoggerFactory.getLogger(DownloadORCIDTest.class);

    @Test
    public void testSummary() throws Exception {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/orcid/summary.xml")));
        OrcidParser parser = new OrcidParser();
        Author orcidItem = parser.parseSummary(xml);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString((Object)orcidItem));
    }

    @Test
    public void testParsingWork() throws Exception {
        List<String> works_path = Arrays.asList("/eu/dnetlib/dhp/collection/orcid/activity_work_0000-0002-2536-4498.xml", "/eu/dnetlib/dhp/collection/orcid/activity_work_0000-0002-5982-8983.xml", "/eu/dnetlib/dhp/collection/orcid/activity_work_0000-0003-2760-1191.xml", "/eu/dnetlib/dhp/collection/orcid/activity_work_0000-0003-2760-1191-similarity.xml", "/eu/dnetlib/dhp/collection/orcid/activity_work_0000-0003-2760-1191_contributors.xml");
        OrcidParser parser = new OrcidParser();
        ObjectMapper mapper = new ObjectMapper();
        works_path.stream().map(s -> {
            try {
                return IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream((String)s)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(s -> {
            try {
                System.out.println(mapper.writeValueAsString((Object)parser.parseWork(s)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Test
    public void testParsingOrcidUpdateEmployments() throws Exception {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/orcid/update_employments.xml")));
        OrcidParser parser = new OrcidParser();
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString((Object)parser.parseEmployments(xml)));
    }

    @Test
    public void testParsingOrcidUpdateWorks() throws Exception {
        String xml = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/orcid/update_work.xml")));
        OrcidParser parser = new OrcidParser();
        List works = parser.parseWorks(xml);
        ObjectMapper mapper = new ObjectMapper();
        System.out.println(mapper.writeValueAsString((Object)works));
    }

    @Test
    public void testParsingEmployments() throws Exception {
        List<String> works_path = Arrays.asList("/eu/dnetlib/dhp/collection/orcid/employment.xml", "/eu/dnetlib/dhp/collection/orcid/employment_2.xml", "/eu/dnetlib/dhp/collection/orcid/employment_3.xml");
        OrcidParser parser = new OrcidParser();
        ObjectMapper mapper = new ObjectMapper();
        works_path.stream().map(s -> {
            try {
                return IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream((String)s)));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).forEach(s -> {
            try {
                System.out.println(mapper.writeValueAsString((Object)parser.parseEmployment(s)));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }
}

