/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.transformativeagreement;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.transformativeagreement.model.TransformativeAgreementModel;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Country;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CreateActionSetSparkJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(CreateActionSetSparkJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String IREL_PROJECT = "40|100018998___::1e5e62235d094afd01cd56e65112fc63";
    private static final String TRANSFORMATIVE_AGREEMENT = "openapc::transformativeagreement";

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(CreateActionSetSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/transformativeagreement/as_parameters.json"))));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> CreateActionSetSparkJob.createActionSet(spark, inputPath, outputPath));
    }

    private static void createActionSet(SparkSession spark, String inputPath, String outputPath) {
        JavaRDD relations = spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> (TransformativeAgreementModel)OBJECT_MAPPER.readValue(value, TransformativeAgreementModel.class), Encoders.bean(TransformativeAgreementModel.class)).flatMap((FlatMapFunction & Serializable)value -> CreateActionSetSparkJob.createRelation(value).iterator(), Encoders.bean(Relation.class)).filter(Objects::nonNull).toJavaRDD().map((Function & Serializable)p -> new AtomicAction(p.getClass(), (Oaf)p));
        spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> (TransformativeAgreementModel)OBJECT_MAPPER.readValue(value, TransformativeAgreementModel.class), Encoders.bean(TransformativeAgreementModel.class)).map((MapFunction & Serializable)value -> CreateActionSetSparkJob.createResult(value), Encoders.bean(Result.class)).filter((FilterFunction & Serializable)r -> r != null).toJavaRDD().map((Function & Serializable)p -> new AtomicAction(p.getClass(), (Oaf)p)).union(relations).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa)))).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, GzipCodec.class);
    }

    private static Result createResult(TransformativeAgreementModel value) {
        Result r = new Result();
        r.setId("50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)value.getDoi())));
        r.setTransformativeAgreement(value.getAgreement());
        Country country = new Country();
        country.setClassid(value.getCountry());
        country.setClassname(value.getCountry());
        country.setDataInfo(OafMapperUtils.dataInfo((Boolean)false, (String)"sysimport:actionset", (Boolean)false, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)TRANSFORMATIVE_AGREEMENT, (String)"Harvested from Trnasformative Agreement file from OpenAPC", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.9"));
        country.setSchemeid("dnet:countries");
        country.setSchemename("dnet:countries");
        r.setCountry(Arrays.asList(country));
        return r;
    }

    private static List<Relation> createRelation(TransformativeAgreementModel value) {
        ArrayList<Relation> relationList = new ArrayList<Relation>();
        if (value.getAgreement().startsWith("IReL")) {
            String paper = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)value.getDoi()));
            relationList.add(CreateActionSetSparkJob.getRelation(paper, IREL_PROJECT, "isProducedBy"));
            relationList.add(CreateActionSetSparkJob.getRelation(IREL_PROJECT, paper, "produces"));
        }
        return relationList;
    }

    public static Relation getRelation(String source, String target, String relClass) {
        return OafMapperUtils.getRelation((String)source, (String)target, (String)"resultProject", (String)"outcome", (String)relClass, Arrays.asList(OafMapperUtils.keyValue((String)"10|apc_________::e2b1600b229fc30663c8a1f662debddf", (String)"OpenAPC Global Initiative")), (DataInfo)OafMapperUtils.dataInfo((Boolean)false, null, (Boolean)false, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)TRANSFORMATIVE_AGREEMENT, (String)"Transformative Agreement", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)"0.9"), null);
    }
}

