/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.mag;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.mag.MAGPaper;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class MagUtility$
implements Serializable {
    public static final MagUtility$ MODULE$;
    private static final ObjectMapper mapper;
    private static final KeyValue MAGCollectedFrom;
    private static final DataInfo MAGDataInfo;
    private static final Map<String, AtomicType> datatypedict;
    private static final Map<String, Tuple2<String, scala.collection.immutable.Seq<String>>> stream;

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        MODULE$ = new MagUtility$();
        mapper = new ObjectMapper();
        MAGCollectedFrom = OafMapperUtils.keyValue((String)"10|openaire____::5f532a3fc4f1ea403f37070f59a7a53a", (String)"Microsoft Academic Graph");
        DataInfo di = new DataInfo();
        di.setDeletedbyinference(Predef$.MODULE$.boolean2Boolean(false));
        di.setInferred(Predef$.MODULE$.boolean2Boolean(false));
        di.setInvisible(Predef$.MODULE$.boolean2Boolean(true));
        di.setTrust("0.9");
        di.setProvenanceaction(OafMapperUtils.qualifier((String)"sysimport:actionset", (String)"sysimport:actionset", (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"));
        MAGDataInfo = var0;
        datatypedict = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bool"), (Object)BooleanType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"int"), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"uint"), (Object)IntegerType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"long"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ulong"), (Object)LongType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"float"), (Object)FloatType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"string"), (Object)StringType$.MODULE$), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"DateTime"), (Object)DateType$.MODULE$)}));
        stream = (Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Affiliations"), (Object)new Tuple2((Object)"mag/Affiliations.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AffiliationId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "GridId:string", "OfficialPage:string", "WikiPage:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "Iso3166Code:string", "Latitude:float?", "Longitude:float?", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"AuthorExtendedAttributes"), (Object)new Tuple2((Object)"mag/AuthorExtendedAttributes.txt", (Object)new .colon.colon((Object)"AuthorId:long", (List)new .colon.colon((Object)"AttributeType:int", (List)new .colon.colon((Object)"AttributeValue:string", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Authors"), (Object)new Tuple2((Object)"mag/Authors.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"AuthorId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "LastKnownAffiliationId:long?", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ConferenceInstances"), (Object)new Tuple2((Object)"mag/ConferenceInstances.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ConferenceInstanceId:long", "NormalizedName:string", "DisplayName:string", "ConferenceSeriesId:long", "Location:string", "OfficialUrl:string", "StartDate:DateTime?", "EndDate:DateTime?", "AbstractRegistrationDate:DateTime?", "SubmissionDeadlineDate:DateTime?", "NotificationDueDate:DateTime?", "FinalVersionDueDate:DateTime?", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "Latitude:float?", "Longitude:float?", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ConferenceSeries"), (Object)new Tuple2((Object)"mag/ConferenceSeries.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ConferenceSeriesId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"EntityRelatedEntities"), (Object)new Tuple2((Object)"advanced/EntityRelatedEntities.txt", (Object)new .colon.colon((Object)"EntityId:long", (List)new .colon.colon((Object)"EntityType:string", (List)new .colon.colon((Object)"RelatedEntityId:long", (List)new .colon.colon((Object)"RelatedEntityType:string", (List)new .colon.colon((Object)"RelatedType:int", (List)new .colon.colon((Object)"Score:float", (List)Nil$.MODULE$)))))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldOfStudyChildren"), (Object)new Tuple2((Object)"advanced/FieldOfStudyChildren.txt", (Object)new .colon.colon((Object)"FieldOfStudyId:long", (List)new .colon.colon((Object)"ChildFieldOfStudyId:long", (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldOfStudyExtendedAttributes"), (Object)new Tuple2((Object)"advanced/FieldOfStudyExtendedAttributes.txt", (Object)new .colon.colon((Object)"FieldOfStudyId:long", (List)new .colon.colon((Object)"AttributeType:int", (List)new .colon.colon((Object)"AttributeValue:string", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FieldsOfStudy"), (Object)new Tuple2((Object)"advanced/FieldsOfStudy.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"FieldOfStudyId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "MainType:string", "Level:int", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Journals"), (Object)new Tuple2((Object)"mag/Journals.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"JournalId:long", "Rank:uint", "NormalizedName:string", "DisplayName:string", "Issn:string", "Publisher:string", "Webpage:string", "PaperCount:long", "PaperFamilyCount:long", "CitationCount:long", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperAbstractsInvertedIndex"), (Object)new Tuple2((Object)"nlp/PaperAbstractsInvertedIndex.txt.*", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"IndexedAbstract:string", (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperAuthorAffiliations"), (Object)new Tuple2((Object)"mag/PaperAuthorAffiliations.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"AuthorId:long", (List)new .colon.colon((Object)"AffiliationId:long?", (List)new .colon.colon((Object)"AuthorSequenceNumber:uint", (List)new .colon.colon((Object)"OriginalAuthor:string", (List)new .colon.colon((Object)"OriginalAffiliation:string", (List)Nil$.MODULE$)))))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperCitationContexts"), (Object)new Tuple2((Object)"nlp/PaperCitationContexts.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"PaperReferenceId:long", (List)new .colon.colon((Object)"CitationContext:string", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperExtendedAttributes"), (Object)new Tuple2((Object)"mag/PaperExtendedAttributes.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"AttributeType:int", (List)new .colon.colon((Object)"AttributeValue:string", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperFieldsOfStudy"), (Object)new Tuple2((Object)"advanced/PaperFieldsOfStudy.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"FieldOfStudyId:long", (List)new .colon.colon((Object)"Score:float", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperMeSH"), (Object)new Tuple2((Object)"advanced/PaperMeSH.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"DescriptorUI:string", (List)new .colon.colon((Object)"DescriptorName:string", (List)new .colon.colon((Object)"QualifierUI:string", (List)new .colon.colon((Object)"QualifierName:string", (List)new .colon.colon((Object)"IsMajorTopic:bool", (List)Nil$.MODULE$)))))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperRecommendations"), (Object)new Tuple2((Object)"advanced/PaperRecommendations.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"RecommendedPaperId:long", (List)new .colon.colon((Object)"Score:float", (List)Nil$.MODULE$))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperReferences"), (Object)new Tuple2((Object)"mag/PaperReferences.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"PaperReferenceId:long", (List)Nil$.MODULE$)))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperResources"), (Object)new Tuple2((Object)"mag/PaperResources.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"ResourceType:int", (List)new .colon.colon((Object)"ResourceUrl:string", (List)new .colon.colon((Object)"SourceUrl:string", (List)new .colon.colon((Object)"RelationshipType:int", (List)Nil$.MODULE$))))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"PaperUrls"), (Object)new Tuple2((Object)"mag/PaperUrls.txt", (Object)new .colon.colon((Object)"PaperId:long", (List)new .colon.colon((Object)"SourceType:int?", (List)new .colon.colon((Object)"SourceUrl:string", (List)new .colon.colon((Object)"LanguageCode:string", (List)Nil$.MODULE$)))))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Papers"), (Object)new Tuple2((Object)"mag/Papers.txt", (Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"PaperId:long", "Rank:uint", "Doi:string", "DocType:string", "PaperTitle:string", "OriginalTitle:string", "BookTitle:string", "Year:int?", "Date:DateTime?", "OnlineDate:DateTime?", "Publisher:string", "JournalId:long?", "ConferenceSeriesId:long?", "ConferenceInstanceId:long?", "Volume:string", "Issue:string", "FirstPage:string", "LastPage:string", "ReferenceCount:long", "CitationCount:long", "EstimatedCitation:long", "OriginalVenue:string", "FamilyId:long?", "FamilyRank:uint?", "DocSubTypes:string", "CreatedDate:DateTime"})))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"RelatedFieldOfStudy"), (Object)new Tuple2((Object)"advanced/RelatedFieldOfStudy.txt", (Object)new .colon.colon((Object)"FieldOfStudyId1:long", (List)new .colon.colon((Object)"Type1:string", (List)new .colon.colon((Object)"FieldOfStudyId2:long", (List)new .colon.colon((Object)"Type2:string", (List)new .colon.colon((Object)"Rank:float", (List)Nil$.MODULE$)))))))}));
    }

    public ObjectMapper mapper() {
        return mapper;
    }

    private KeyValue MAGCollectedFrom() {
        return MAGCollectedFrom;
    }

    private DataInfo MAGDataInfo() {
        return MAGDataInfo;
    }

    public Map<String, AtomicType> datatypedict() {
        return datatypedict;
    }

    public Map<String, Tuple2<String, scala.collection.immutable.Seq<String>>> stream() {
        return stream;
    }

    public StructType getSchema(String streamName) {
        ObjectRef schema = ObjectRef.create((Object)new StructType());
        scala.collection.immutable.Seq d = (scala.collection.immutable.Seq)((Tuple2)this.stream().apply((Object)streamName))._2();
        d.foreach((Function1 & Serializable)t -> {
            MagUtility$.$anonfun$getSchema$1(schema, t);
            return BoxedUnit.UNIT;
        });
        return (StructType)schema.elem;
    }

    public org.apache.spark.sql.Dataset<Row> loadMagEntity(SparkSession spark, String entity, String basePath) {
        if (this.stream().contains((Object)entity)) {
            StructType s = this.getSchema(entity);
            String pt = (String)((Tuple2)this.stream().apply((Object)entity))._1();
            return spark.read().option("header", "false").option("charset", "UTF8").option("delimiter", "\t").schema(s).csv(basePath + "/" + pt);
        }
        return null;
    }

    public Result createResultFromType(Option<String> magType, Option<String> source) {
        Publication result;
        block20: {
            Qualifier qualifier;
            String currentType;
            block19: {
                result = null;
                if (magType == null || magType.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) == null) {
                    result = new Publication();
                    result.setDataInfo(this.MAGDataInfo());
                    Instance i = new Instance();
                    i.setInstancetype(OafMapperUtils.qualifier((String)"0038", (String)"Other literature type", (String)"dnet:publication_resource", (String)"dnet:publication_resource"));
                    result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
                    return result;
                }
                currentType = (String)magType.get();
                String string = currentType.toLowerCase();
                switch (string == null ? 0 : string.hashCode()) {
                    case -1419464905: {
                        if (!"journal".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case -995364504: {
                        if (!"patent".equals(string)) break;
                        if (source != null && source.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) != null) {
                            String s = ((String)source.get()).toLowerCase();
                            if (s.contains("patent") || s.contains("brevet")) {
                                result = new Publication();
                                qualifier = OafMapperUtils.qualifier((String)"0019", (String)"Patent", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                            } else if (s.contains("journal of")) {
                                result = new Publication();
                                qualifier = OafMapperUtils.qualifier((String)"0043", (String)"Journal", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                            } else if (s.contains("proceedings") || s.contains("conference") || s.contains("workshop") || s.contains("symposium")) {
                                result = new Publication();
                                qualifier = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                            } else {
                                qualifier = null;
                            }
                        } else {
                            qualifier = null;
                        }
                        break block19;
                    }
                    case -874816820: {
                        if (!"thesis".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0044", (String)"Thesis", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case -868558524: {
                        if (!"bookchapter".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"00013", (String)"Part of book or chapter of book", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case 3029737: {
                        if (!"book".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0002", (String)"Book", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case 727663900: {
                        if (!"conference".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0001", (String)"Article", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case 1443214456: {
                        if (!"dataset".equals(string)) break;
                        result = new Dataset();
                        qualifier = OafMapperUtils.qualifier((String)"0021", (String)"Dataset", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                    case 1950800714: {
                        if (!"repository".equals(string)) break;
                        result = new Publication();
                        qualifier = OafMapperUtils.qualifier((String)"0038", (String)"Other literature type", (String)"dnet:publication_resource", (String)"dnet:publication_resource");
                        break block19;
                    }
                }
                throw new MatchError((Object)string);
            }
            Qualifier tp = qualifier;
            if (result == null) break block20;
            result.setDataInfo(this.MAGDataInfo());
            Instance i = new Instance();
            i.setInstancetype(tp);
            i.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.instanceTypeMapping((String)currentType, (String)"openaire::coar_resource_types_3_1"), (List)Nil$.MODULE$)).asJava());
            result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
        }
        return result;
    }

    public void patchTypology(Result r) {
        ((Instance)r.getInstance().get(0)).setInstancetype(OafMapperUtils.qualifier((String)"0014", (String)"Research", (String)"dnet:publication_resource", (String)"dnet:publication_resource"));
    }

    public String convertMAGtoOAF(MAGPaper paper) {
        if (paper.urls().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) == null) {
            return null;
        }
        Result result = this.createResultFromType(paper.docType(), paper.originalVenue());
        if (result == null) {
            return null;
        }
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.MAGCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        .colon.colon pidList = new .colon.colon((Object)OafMapperUtils.structuredProperty((String)paper.paperId().get().toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)Nil$.MODULE$);
        result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pidList.map((Function1 & Serializable)s -> s.getValue())).asJava());
        result.setId("50|mag_________::" + DHPUtils.md5((String)paper.paperId().get().toString()));
        StructuredProperty originalTitles = OafMapperUtils.structuredProperty((String)((String)paper.paperTitle().get()), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null);
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)originalTitles, (List)Nil$.MODULE$)).asJava());
        if (paper.abstractText().isDefined()) {
            result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.field((Object)paper.abstractText().get(), null), (List)Nil$.MODULE$)).asJava());
        }
        Instance instance = (Instance)result.getInstance().get(0);
        if (paper.doi().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) != null) {
            .colon.colon colon2 = pidList;
            pidList = new .colon.colon((Object)OafMapperUtils.structuredProperty((String)((String)paper.doi().get()), (Qualifier)OafMapperUtils.qualifier((String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)Nil$.MODULE$).$colon$colon$colon((List)colon2);
        }
        instance.setAlternateIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)pidList).asJava());
        instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)("https://dx.doi.org/" + paper.doi().getOrElse((Function0 & Serializable)() -> "")), (List)Nil$.MODULE$)).asJava());
        instance.setCollectedfrom(this.MAGCollectedFrom());
        return this.mapper().writeValueAsString((Object)result);
    }

    public String generateOrganization(Row r) {
        Organization o = new Organization();
        String affId = "20|mag_________::" + DHPUtils.md5((String)r.getAs("AffiliationId").toString());
        o.setId(affId);
        o.setDataInfo(this.MAGDataInfo());
        o.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.MAGCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        o.setLegalname(OafMapperUtils.field((Object)r.getAs("DisplayName"), null));
        String gid = (String)r.getAs("GridId");
        if (gid != null) {
            o.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)gid, (Qualifier)OafMapperUtils.qualifier((String)PidType.GRID.toString(), (String)PidType.GRID.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)r.getAs("AffiliationId").toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)Nil$.MODULE$))).asJava());
        } else {
            o.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)OafMapperUtils.structuredProperty((String)r.getAs("AffiliationId").toString(), (Qualifier)OafMapperUtils.qualifier((String)PidType.mag_id.toString(), (String)PidType.mag_id.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types"), null), (List)Nil$.MODULE$)).asJava());
        }
        String c = (String)r.getAs("Iso3166Code");
        if (c != null) {
            o.setCountry(OafMapperUtils.qualifier((String)c, (String)c, (String)"dnet:countries", (String)"dnet:countries"));
        } else {
            o.setCountry(ModelConstants.UNKNOWN_COUNTRY);
        }
        String ws = (String)r.getAs("OfficialPage");
        if (ws != null) {
            o.setWebsiteurl(OafMapperUtils.field((Object)ws, null));
        }
        AtomicAction a = new AtomicAction();
        a.setClazz(Organization.class);
        a.setPayload((Oaf)o);
        return this.mapper().writeValueAsString((Object)a);
    }

    public List<Relation> generateAffiliationRelations(Row paperAffiliation) {
        String affId = "20|mag_________::" + DHPUtils.md5((String)paperAffiliation.getAs("AffiliationId").toString());
        String oafId = "50|mag_________::" + DHPUtils.md5((String)paperAffiliation.getAs("PaperId").toString());
        Relation r = new Relation();
        r.setSource(oafId);
        r.setTarget(affId);
        r.setRelType("resultOrganization");
        r.setRelClass("hasAuthorInstitution");
        r.setSubRelType("affiliation");
        r.setDataInfo(this.MAGDataInfo());
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.MAGCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        Relation r1 = new Relation();
        r1.setTarget(oafId);
        r1.setSource(affId);
        r1.setRelType("resultOrganization");
        r1.setRelClass("isAuthorInstitutionOf");
        r1.setSubRelType("affiliation");
        r1.setDataInfo(this.MAGDataInfo());
        r1.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)this.MAGCollectedFrom(), (List)Nil$.MODULE$)).asJava());
        return new .colon.colon((Object)r, (List)new .colon.colon((Object)r1, (List)Nil$.MODULE$));
    }

    public String convertInvertedIndexString(String json_input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        int idl = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(MagUtility$.json$1(json$lzy, json_input)), "IndexLength")), (Formats)MagUtility$.formats$1(formats$lzy), (Manifest)ManifestFactory$.MODULE$.Int()));
        if (idl > 0) {
            String[] res = (String[])Array$.MODULE$.ofDim(idl, ClassTag$.MODULE$.apply(String.class));
            Map iid = (Map)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(MagUtility$.json$1(json$lzy, json_input)), "InvertedIndex")), (Formats)MagUtility$.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(List.class, (Manifest)ManifestFactory$.MODULE$.Int(), (scala.collection.immutable.Seq)Nil$.MODULE$)})));
            iid.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MagUtility$.$anonfun$convertInvertedIndexString$1(check$ifrefutable$1))).foreach((Function1 & Serializable)x$1 -> {
                MagUtility$.$anonfun$convertInvertedIndexString$2(res, x$1);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), idl).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (res[i] == null) {
                    res$1[i] = "";
                    return;
                }
            });
            return Predef$.MODULE$.wrapRefArray((Object[])res).mkString(" ");
        }
        return "";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MagUtility$.class);
    }

    public static final /* synthetic */ void $anonfun$getSchema$1(ObjectRef schema$1, String t) {
        String[] currentType = t.split(":");
        String fieldName = (String)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.refArrayOps((Object[])currentType));
        String fieldType = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])currentType));
        boolean nullable = fieldType.endsWith("?");
        if (nullable) {
            fieldType = fieldType.replace("?", "");
        }
        schema$1.elem = ((StructType)schema$1.elem).add(new StructField(fieldName, (DataType)MODULE$.datatypedict().apply((Object)fieldType), nullable, StructField$.MODULE$.apply$default$4()));
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return MagUtility$.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JValue json$lzycompute$1(LazyRef json$lzy$1, String json_input$1) {
        JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JValue)json$lzy$1.value() : (JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse((Object)json_input$1, JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput()));
        }
        return jValue;
    }

    private static final JValue json$1(LazyRef json$lzy$1, String json_input$1) {
        if (json$lzy$1.initialized()) {
            return (JValue)json$lzy$1.value();
        }
        return MagUtility$.json$lzycompute$1(json$lzy$1, json_input$1);
    }

    public static final /* synthetic */ boolean $anonfun$convertInvertedIndexString$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            List v = (List)tuple2._2();
            if (k != null && v != null) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ void $anonfun$convertInvertedIndexString$2(String[] res$1, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            List v = (List)tuple2._2();
            if (k != null) {
                String string = k;
                if (v != null) {
                    List list = v;
                    list.foreach((Function1)(JFunction1.mcVI.sp & Serializable)item -> {
                        res$1[item] = string;
                    });
                    return;
                }
            }
        }
        throw new MatchError((Object)tuple2);
    }

    private MagUtility$() {
    }
}

