/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ORCIDWorker
extends Thread {
    static final Logger log = LoggerFactory.getLogger(ORCIDWorker.class);
    public static String JOB_COMPLETE = "JOB_COMPLETE";
    private static final String userAgent = "Mozilla/5.0 (compatible; OAI; +http://www.openaire.eu)";
    private final BlockingQueue<String> queue;
    private boolean hasComplete = false;
    private final SequenceFile.Writer employments;
    private final SequenceFile.Writer summary;
    private final SequenceFile.Writer works;
    private final String token;
    private final String id;

    public static ORCIDWorkerBuilder builder() {
        return new ORCIDWorkerBuilder();
    }

    public ORCIDWorker(String id, BlockingQueue<String> myqueue, SequenceFile.Writer employments, SequenceFile.Writer summary, SequenceFile.Writer works, String token) {
        this.id = id;
        this.queue = myqueue;
        this.employments = employments;
        this.summary = summary;
        this.works = works;
        this.token = token;
    }

    public static String retrieveURL(String id, String apiUrl, String token) {
        try {
            HttpURLConnection urlConn = ORCIDWorker.getHttpURLConnection(apiUrl, token);
            if (urlConn.getResponseCode() > 199 && urlConn.getResponseCode() < 300) {
                InputStream input = urlConn.getInputStream();
                return IOUtils.toString((InputStream)input);
            }
            log.error("Thread {} UNABLE TO DOWNLOAD FROM THIS URL {} , status code {}", new Object[]{id, apiUrl, urlConn.getResponseCode()});
        }
        catch (Exception e) {
            log.error("Thread {}  Error on retrieving URL {} {}", new Object[]{id, apiUrl, e});
        }
        return null;
    }

    @NotNull
    private static HttpURLConnection getHttpURLConnection(String apiUrl, String token) throws IOException {
        HttpURLConnection urlConn = (HttpURLConnection)new URL(apiUrl).openConnection();
        HttpClientParams clientParams = new HttpClientParams();
        urlConn.setInstanceFollowRedirects(false);
        urlConn.setReadTimeout(clientParams.getReadTimeOut() * 1000);
        urlConn.setConnectTimeout(clientParams.getConnectTimeOut() * 1000);
        urlConn.addRequestProperty("User-Agent", userAgent);
        urlConn.addRequestProperty("Authorization", String.format("Bearer %s", token));
        return urlConn;
    }

    private static String generateSummaryURL(String orcidId) {
        return "https://api.orcid.org/v3.0/" + orcidId + "/record";
    }

    private static String generateWorksURL(String orcidId) {
        return "https://api.orcid.org/v3.0/" + orcidId + "/works";
    }

    private static String generateEmploymentsURL(String orcidId) {
        return "https://api.orcid.org/v3.0/" + orcidId + "/employments";
    }

    private static void writeResultToSequenceFile(String id, String url, String token, String orcidId, SequenceFile.Writer file) throws IOException {
        String response = ORCIDWorker.retrieveURL(id, url, token);
        if (response != null) {
            if (orcidId == null) {
                log.error("Thread {}   {}   {}", new Object[]{id, orcidId, response});
                throw new RuntimeException("null items ");
            }
            if (file == null) {
                log.error("Thread {}   file is null for {}  URL:{}", new Object[]{id, url, orcidId});
            } else {
                file.append((Writable)new Text(orcidId), (Writable)new Text(response));
                file.hflush();
            }
        } else {
            log.error("Thread {} response is null for {}  URL:{}", new Object[]{id, url, orcidId});
        }
    }

    @Override
    public void run() {
        Text key = new Text();
        Text value = new Text();
        String orcidId = "";
        int requests = 0;
        if (this.summary == null || this.employments == null || this.works == null) {
            throw new RuntimeException("Null files");
        }
        while (!this.hasComplete) {
            try {
                orcidId = this.queue.take();
                if (orcidId.equalsIgnoreCase(JOB_COMPLETE)) {
                    this.hasComplete = true;
                    continue;
                }
                long start = System.currentTimeMillis();
                ORCIDWorker.writeResultToSequenceFile(this.id, ORCIDWorker.generateSummaryURL(orcidId), this.token, orcidId, this.summary);
                long total_time = System.currentTimeMillis() - start;
                ++requests;
                if (total_time < 1000L) {
                    Thread.sleep(1000L - total_time);
                }
                start = System.currentTimeMillis();
                ORCIDWorker.writeResultToSequenceFile(this.id, ORCIDWorker.generateWorksURL(orcidId), this.token, orcidId, this.works);
                total_time = System.currentTimeMillis() - start;
                ++requests;
                if (total_time < 1000L) {
                    Thread.sleep(1000L - total_time);
                }
                start = System.currentTimeMillis();
                ORCIDWorker.writeResultToSequenceFile(this.id, ORCIDWorker.generateEmploymentsURL(orcidId), this.token, orcidId, this.employments);
                total_time = System.currentTimeMillis() - start;
                ++requests;
                if (total_time < 1000L) {
                    Thread.sleep(1000L - total_time);
                }
                if (requests % 30 != 0) continue;
                log.info("Thread {}   Downloaded {}", (Object)this.id, (Object)requests);
            }
            catch (Throwable e) {
                log.error("Thread {}  Unable to save ORICD: {} item error", new Object[]{this.id, orcidId, e});
            }
        }
        try {
            this.works.close();
            this.summary.close();
            this.employments.close();
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        log.info("Thread {}  COMPLETE ", (Object)this.id);
        log.info("Thread {}   Downloaded {}", (Object)this.id, (Object)requests);
    }

    public static class ORCIDWorkerBuilder {
        private String id;
        private SequenceFile.Writer employments;
        private SequenceFile.Writer summary;
        private SequenceFile.Writer works;
        private BlockingQueue<String> queue;
        private String token;

        public ORCIDWorkerBuilder withId(String id) {
            this.id = id;
            return this;
        }

        public ORCIDWorkerBuilder withEmployments(SequenceFile.Writer sequenceFile) {
            this.employments = sequenceFile;
            return this;
        }

        public ORCIDWorkerBuilder withSummary(SequenceFile.Writer sequenceFile) {
            this.summary = sequenceFile;
            return this;
        }

        public ORCIDWorkerBuilder withWorks(SequenceFile.Writer sequenceFile) {
            this.works = sequenceFile;
            return this;
        }

        public ORCIDWorkerBuilder withAccessToken(String accessToken) {
            this.token = accessToken;
            return this;
        }

        public ORCIDWorkerBuilder withBlockingQueue(BlockingQueue<String> queue) {
            this.queue = queue;
            return this;
        }

        public ORCIDWorker build() {
            if (this.summary == null || this.works == null || this.employments == null || StringUtils.isEmpty((CharSequence)this.token) || this.queue == null) {
                throw new RuntimeException("Unable to build missing required params");
            }
            return new ORCIDWorker(this.id, this.queue, this.employments, this.summary, this.works, this.token);
        }
    }
}

