/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.blacklist;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareMergedRelationJob {
    private static final Logger log = LoggerFactory.getLogger(PrepareMergedRelationJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareMergedRelationJob.class.getResourceAsStream("/eu/dnetlib/dhp/blacklist/input_preparerelation_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("sourcePath");
        log.info("inputPath: {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {} ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        conf.set("hive.metastore.uris", parser.get("hive_metastore_uris"));
        SparkSessionSupport.runWithSparkHiveSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PrepareMergedRelationJob.removeOutputDir(spark, outputPath);
            PrepareMergedRelationJob.selectMergesRelations(spark, inputPath, outputPath);
        });
    }

    private static void selectMergesRelations(SparkSession spark, String inputPath, String outputPath) {
        Dataset<Relation> relation = PrepareMergedRelationJob.readRelations(spark, inputPath);
        relation.filter("relclass = 'merges' and datainfo.deletedbyinference=false").write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath);
    }

    public static Dataset<Relation> readRelations(SparkSession spark, String inputPath) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> (Relation)OBJECT_MAPPER.readValue(value, Relation.class), Encoders.bean(Relation.class));
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }
}

