package eu.dnetlib.lbs.controllers;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import eu.dnetlib.lbs.LiteratureBrokerServiceConfiguration;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

@RestController
@RequestMapping("/api/notifications")
@Api(tags = LiteratureBrokerServiceConfiguration.TAG_NOTIFICATIONS)
public class NotificationsController extends AbstractLbsController {

	@Autowired
	private NotificationRepository notificationRepository;

	@ApiOperation("Return a notification by ID")
	@GetMapping("/{id}")
	public Notification getNotification(@PathVariable final String id) {
		return notificationRepository.findById(id).get();
	}

	@ApiOperation("Delete a notification by ID")
	@DeleteMapping("/{id}")
	public void deleteNotification(@PathVariable final String id) {
		notificationRepository.deleteById(id);
	}

	@ApiOperation("Save a notification by ID")
	@PostMapping("/{id}")
	public Notification saveNotification(@RequestBody final Notification notification) {
		return notificationRepository.save(notification);
	}

	@ApiOperation("Delete all notifications")
	@DeleteMapping("")
	public void deleteAllNotifications() {
		notificationRepository.deleteAll();
	}

}
