/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.events.output;

import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.events.output.NotificationDispatcher;
import eu.dnetlib.lbs.subscriptions.Subscription;
import eu.dnetlib.lbs.utils.LbsQueue;
import eu.dnetlib.lbs.utils.QueueManager;
import eu.dnetlib.lbs.utils.ThreadManager;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractNotificationDispatcher<T>
implements NotificationDispatcher,
BeanNameAware,
Runnable {
    private String dispatcherName;
    @Autowired
    private QueueManager queueManager;
    @Autowired
    private ThreadManager threadManager;
    private LbsQueue<T, T> queue;
    private final AtomicLong count = new AtomicLong(0L);
    private static final Log log = LogFactory.getLog(AbstractNotificationDispatcher.class);

    @PostConstruct
    public void init() {
        this.queue = this.queueManager.newQueue(this.dispatcherName + "-queue");
        this.threadManager.newThread(this.dispatcherName, this);
    }

    @Override
    public void run() {
        block2: while (true) {
            Iterator<T> iterator = this.queue.takeList().iterator();
            while (true) {
                if (!iterator.hasNext()) continue block2;
                T message = iterator.next();
                if (message == null) continue;
                try {
                    this.performAction(message);
                    this.count.incrementAndGet();
                    continue;
                }
                catch (Throwable e) {
                    log.error((Object)"Error sending notification", e);
                    this.queue.offer(message);
                    continue;
                }
                break;
            }
            break;
        }
    }

    @Override
    public void sendNotification(Subscription subscription, Event ... events) {
        try {
            this.queue.offer(this.prepareAction(subscription, events));
        }
        catch (Exception e) {
            log.error((Object)"Error sending notification", (Throwable)e);
        }
    }

    protected abstract T prepareAction(Subscription var1, Event ... var2) throws Exception;

    protected abstract void performAction(T var1) throws Exception;

    @Override
    public String getDispatcherName() {
        return this.dispatcherName;
    }

    public void setDispatcherName(String dispatcherName) {
        this.dispatcherName = dispatcherName;
    }

    @Override
    public long count() {
        return this.count.get();
    }

    @Override
    public void resetCount() {
        this.count.set(0L);
    }

    public void setBeanName(String name) {
        if (StringUtils.isBlank((CharSequence)this.getDispatcherName())) {
            this.setDispatcherName(name);
        }
    }
}

