#!/bin/bash

INDEXBASEURL=http://localhost:9200
INDEXNAME=events_beta_michele

echo
echo "Fixing events index..."
curl -XPUT -H 'Content-Type: application/json' "$INDEXBASEURL/$INDEXNAME/_mapping" -d '
{
	"properties" : {
		"map": {
			"type": "nested",
			"properties": {
				"targetDatasourceId": {
					"type": "keyword",
					"index": true
				},
				"targetDatasourceName": {
					"type": "keyword",
					"index": true
				},
				"targetDatasourceType": {
					"type": "keyword",
					"index": true
				}
			}
		}
	}
}'

echo
echo
echo "Fixing notifications index..."
curl -XPUT -H 'Content-Type: application/json' "$INDEXBASEURL/$INDEXNAME/_mapping" -d '
{
	"properties" : {
		"map": {
			"type": "nested",
			"properties": {
				"targetDatasourceId": {
					"type": "keyword",
					"index": true
				},
				"targetDatasourceName": {
					"type": "keyword",
					"index": true
				},
				"targetDatasourceType": {
					"type": "keyword",
					"index": true
				}
			}
		}
	}
}'

echo
echo
echo "Registering topic type: ENRICH/<cond>/<field>..."
curl "http://localhost:8080/api/topic-types/add" -d "name=ENRICH&expression=ENRICH%2F%3Ccond%3E%2F%3Cfield%3E&producerId=OpenAIRE&mapKeys=targetDatasourceName"
echo
echo
echo "Registering topic type: ENRICH/<cond>/<field>/<subfield>..."
curl "http://localhost:8080/api/topic-types/add" -d "name=ENRICH_WITH_SUBFIELD&expression=ENRICH%2F%3Ccond%3E%2F%3Cfield%3E%2F%3Csubfield%3E&producerId=OpenAIRE&mapKeys=targetDatasourceName"
echo
echo
echo "Registering topic type: ADD/<field>..."
curl "http://localhost:8080/api/topic-types/add" -d "name=ADD&expression=ADD%2F%3Cfield%3E&producerId=OpenAIRE&mapKeys=targetDatasourceName"
echo
echo
echo
