/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.utils;

import eu.dnetlib.lbs.utils.LbsQueue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class QueueManager {
    final List<LbsQueue<?, ?>> lbsQueues = new ArrayList();
    @Value(value="${lbs.queues.maxReturnedValues}")
    private int maxReturnedValues;

    public <T, K> LbsQueue<T, K> newQueue(String name, Function<T, K> func, Predicate<K> predicate) {
        LbsQueue<T, K> queue = new LbsQueue<T, K>(name, func, predicate, this.maxReturnedValues);
        this.lbsQueues.add(queue);
        return queue;
    }

    public <K> LbsQueue<K, K> newQueue(String name, Predicate<K> predicate) {
        return this.newQueue(name, s -> s, predicate);
    }

    public <K> LbsQueue<K, K> newQueue(String name) {
        return this.newQueue(name, s -> s, Objects::nonNull);
    }

    public List<LbsQueue<?, ?>> getLbsQueues() {
        return this.lbsQueues;
    }
}

