/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.openaire;

import eu.dnetlib.lbs.openaire.Range;
import eu.dnetlib.lbs.utils.DateParser;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.search.MatchQuery;

public class ElasticSearchQueryUtils {
    public static void addMapConditionForTrust(BoolQueryBuilder mapQuery, String field, Range trust) {
        double min = NumberUtils.toDouble((String)trust.getMin(), (double)0.0);
        double max = NumberUtils.toDouble((String)trust.getMax(), (double)1.0);
        mapQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)field).from((Object)min).to((Object)max));
    }

    public static void addMapCondition(BoolQueryBuilder mapQuery, String field, String value) {
        if (StringUtils.isNotBlank((CharSequence)value)) {
            mapQuery.must((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)value).operator(Operator.AND).zeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL));
        }
    }

    public static void addMapCondition(BoolQueryBuilder mapQuery, String field, List<String> list) {
        if (list != null && list.size() > 0) {
            BoolQueryBuilder listQuery = QueryBuilders.boolQuery();
            for (String s : list) {
                listQuery.should((QueryBuilder)QueryBuilders.matchQuery((String)field, (Object)s).operator(Operator.AND).zeroTermsQuery(MatchQuery.ZeroTermsQuery.ALL));
            }
            mapQuery.must((QueryBuilder)listQuery);
        }
    }

    public static void addMapConditionForDates(BoolQueryBuilder mapQuery, String field, List<Range> list) {
        if (list != null && list.size() > 0) {
            BoolQueryBuilder listQuery = QueryBuilders.boolQuery();
            for (Range range : list) {
                long min = ElasticSearchQueryUtils.calculateTime(range.getMin(), 0L);
                long max = ElasticSearchQueryUtils.calculateTime(range.getMax(), Long.MAX_VALUE);
                listQuery.should((QueryBuilder)QueryBuilders.rangeQuery((String)field).from((Object)min).to((Object)max));
            }
            mapQuery.must((QueryBuilder)listQuery);
        }
    }

    public static long calculateTime(String s, long defaultValue) {
        Date date = DateParser.parse(s);
        return date != null ? date.getTime() : defaultValue;
    }
}

