/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.openaire;

import com.google.gson.Gson;
import eu.dnetlib.broker.objects.OaBrokerEventPayload;
import eu.dnetlib.lbs.controllers.AbstractLbsController;
import eu.dnetlib.lbs.elasticsearch.Event;
import eu.dnetlib.lbs.elasticsearch.Notification;
import eu.dnetlib.lbs.elasticsearch.NotificationRepository;
import eu.dnetlib.lbs.openaire.AdvQueryObject;
import eu.dnetlib.lbs.openaire.BrowseEntry;
import eu.dnetlib.lbs.openaire.ElasticSearchQueryUtils;
import eu.dnetlib.lbs.openaire.EventsPage;
import eu.dnetlib.lbs.openaire.OpenaireSubscription;
import eu.dnetlib.lbs.openaire.ScrollPage;
import eu.dnetlib.lbs.openaire.SimpleSubscriptionDesc;
import eu.dnetlib.lbs.properties.ElasticSearchProperties;
import eu.dnetlib.lbs.subscriptions.ConditionParams;
import eu.dnetlib.lbs.subscriptions.MapCondition;
import eu.dnetlib.lbs.subscriptions.Subscription;
import eu.dnetlib.lbs.subscriptions.SubscriptionRepository;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.ElasticsearchRestTemplate;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.SearchScrollHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/openaireBroker"})
@Api(tags={"OpenAIRE"})
public class OpenaireBrokerController
extends AbstractLbsController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private ElasticSearchProperties props;
    private static final long SCROLL_TIMEOUT_IN_MILLIS = 300000L;
    private static final Log log = LogFactory.getLog(OpenaireBrokerController.class);

    @ApiOperation(value="Return the datasources having events")
    @GetMapping(value={"/datasources"})
    public List<BrowseEntry> findDatasourcesWithEvents() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withSearchType(SearchType.DEFAULT).addAggregation(AggregationBuilders.nested((String)"nested", (String)"map").subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"by_map").field("map.targetDatasourceName")).size(1000).minDocCount(1L))).build();
        SearchHits hits = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        Aggregation aggByMap = (Aggregation)((ParsedNested)aggregations.asMap().get("nested")).getAggregations().asMap().get("by_map");
        return ((ParsedStringTerms)aggByMap).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    @ApiOperation(value="Return the topics of the events of a datasource")
    @GetMapping(value={"/topicsForDatasource"})
    public List<BrowseEntry> findTopicsForDatasource(@RequestParam String ds) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.targetDatasourceName", (Object)ds), (ScoreMode)ScoreMode.None)).withSearchType(SearchType.DEFAULT).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"topic").field("topic")).size(1000).minDocCount(1L)).build();
        SearchHits hits = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        return ((ParsedStringTerms)aggregations.asMap().get("topic")).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    @ApiOperation(value="Return a page of events of a datasource (by topic)")
    @GetMapping(value={"/events/{nPage}/{size}"})
    public EventsPage showEvents(@RequestParam String ds, @RequestParam String topic, @PathVariable int nPage, @PathVariable int size) {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)topic)).must((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.targetDatasourceName", (Object)ds), (ScoreMode)ScoreMode.None))).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        SearchHits page = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        List<OaBrokerEventPayload> list = page.stream().map(SearchHit::getContent).map(Event::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(ds, topic, nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
    }

    @ApiOperation(value="Return a page of events of a datasource (by query)")
    @PostMapping(value={"/events/{nPage}/{size}"})
    public EventsPage advancedShowEvents(@PathVariable int nPage, @PathVariable int size, @RequestBody AdvQueryObject qObj) {
        BoolQueryBuilder mapQuery = QueryBuilders.boolQuery();
        ElasticSearchQueryUtils.addMapCondition(mapQuery, "map.targetDatasourceName", qObj.getDatasource());
        ElasticSearchQueryUtils.addMapCondition(mapQuery, "map.targetResultTitle", qObj.getTitles());
        ElasticSearchQueryUtils.addMapCondition(mapQuery, "map.targetAuthors", qObj.getAuthors());
        ElasticSearchQueryUtils.addMapCondition(mapQuery, "map.targetSubjects", qObj.getSubjects());
        ElasticSearchQueryUtils.addMapConditionForTrust(mapQuery, "map.trust", qObj.getTrust());
        ElasticSearchQueryUtils.addMapConditionForDates(mapQuery, "map.targetDateofacceptance", qObj.getDates());
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)qObj.getTopic())).must((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)mapQuery, (ScoreMode)ScoreMode.None))).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        SearchHits page = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        List<OaBrokerEventPayload> list = page.stream().map(SearchHit::getContent).map(Event::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(qObj.getDatasource(), qObj.getTopic(), nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
    }

    @ApiOperation(value="Perform a subscription")
    @PostMapping(value={"/subscribe"})
    public Subscription registerSubscription(@RequestBody OpenaireSubscription oSub) {
        Subscription sub = oSub.asSubscription();
        this.subscriptionRepo.save(sub);
        return sub;
    }

    @ApiOperation(value="Return the subscriptions of an user (by email)")
    @GetMapping(value={"/subscriptions"})
    public Map<String, List<SimpleSubscriptionDesc>> subscriptions(@RequestParam String email) {
        Iterable<Subscription> iter = this.subscriptionRepo.findBySubscriber(email);
        return StreamSupport.stream(iter.spliterator(), false).map(this::subscriptionDesc).collect(Collectors.groupingBy(SimpleSubscriptionDesc::getDatasource));
    }

    @ApiOperation(value="Return a page of notifications")
    @GetMapping(value={"/notifications/{subscrId}/{nPage}/{size}"})
    public EventsPage notifications(@PathVariable String subscrId, @PathVariable int nPage, @PathVariable int size) {
        Optional optSub = this.subscriptionRepo.findById(subscrId);
        if (optSub.isPresent()) {
            Subscription sub = (Subscription)optSub.get();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"subscriptionId", (Object)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
            SearchHits page = this.esOperations.search((Query)searchQuery, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
            List<OaBrokerEventPayload> list = page.stream().map(SearchHit::getContent).map(Notification::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
            return new EventsPage(this.extractDatasource(sub), sub.getTopic(), nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new EventsPage("", "", nPage, 0L, 0L, new ArrayList<OaBrokerEventPayload>());
    }

    @ApiOperation(value="Returns notifications using scrolls (first page)")
    @GetMapping(value={"/scroll/notifications/start/{subscrId}"})
    public ScrollPage prepareScrollNotifications(@PathVariable String subscrId) {
        Optional optSub = this.subscriptionRepo.findById(subscrId);
        if (optSub.isPresent()) {
            ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchQuery((String)"subscriptionId", (Object)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).build();
            SearchScrollHits scroll = esTemplate.searchScrollStart(300000L, (Query)searchQuery, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
            if (scroll.hasSearchHits()) {
                List<OaBrokerEventPayload> values = this.calculateEventPayloads((SearchScrollHits<Notification>)scroll);
                return new ScrollPage(scroll.getScrollId(), values.isEmpty() || scroll.getScrollId() == null, values);
            }
            esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
            return new ScrollPage(null, true, new ArrayList<OaBrokerEventPayload>());
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new ScrollPage();
    }

    @ApiOperation(value="Returns notifications using scrolls (other pages)")
    @GetMapping(value={"/scroll/notifications/{scrollId}"})
    public ScrollPage scrollNotifications(@PathVariable String scrollId) {
        ElasticsearchRestTemplate esTemplate = (ElasticsearchRestTemplate)this.esOperations;
        SearchScrollHits scroll = esTemplate.searchScrollContinue(scrollId, 300000L, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
        if (scroll.hasSearchHits()) {
            List<OaBrokerEventPayload> values = this.calculateEventPayloads((SearchScrollHits<Notification>)scroll);
            return new ScrollPage(scroll.getScrollId(), values.isEmpty() || scroll.getScrollId() == null, values);
        }
        esTemplate.searchScrollClear(Arrays.asList(scroll.getScrollId()));
        return new ScrollPage(null, true, new ArrayList<OaBrokerEventPayload>());
    }

    private List<OaBrokerEventPayload> calculateEventPayloads(SearchScrollHits<Notification> scroll) {
        if (scroll.getSearchHits().size() > 0) {
            Gson gson = new Gson();
            return scroll.stream().map(SearchHit::getContent).map(Notification::getPayload).map(s -> (OaBrokerEventPayload)gson.fromJson(s, OaBrokerEventPayload.class)).collect(Collectors.toList());
        }
        return new ArrayList<OaBrokerEventPayload>();
    }

    private SimpleSubscriptionDesc subscriptionDesc(Subscription s) {
        return new SimpleSubscriptionDesc(s.getSubscriptionId(), this.extractDatasource(s), s.getTopic(), s.getCreationDate(), s.getLastNotificationDate(), this.notificationRepository.countBySubscriptionId(s.getSubscriptionId()));
    }

    private String extractDatasource(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> c.getField().equals("targetDatasourceName")).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().get();
    }

    private long overrideGetTotalPage(SearchHits<?> page, int size) {
        return (page.getTotalHits() + (long)size - 1L) / (long)size;
    }
}

