/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.lbs.subscriptions;

import eu.dnetlib.lbs.subscriptions.ConditionOperator;
import eu.dnetlib.lbs.utils.DateParser;
import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConditionParams {
    private String value;
    private String otherValue;

    public ConditionParams() {
    }

    public ConditionParams(String value, String otherValue) {
        this.value = value;
        this.otherValue = otherValue;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getOtherValue() {
        return this.otherValue;
    }

    public void setOtherValue(String otherValue) {
        this.otherValue = otherValue;
    }

    public boolean verify(String s, ConditionOperator operator) {
        Set<String> set = this.tokenize(s);
        switch (operator) {
            case EXACT: {
                return StringUtils.equalsIgnoreCase((CharSequence)s, (CharSequence)this.value);
            }
            case MATCH_ANY: {
                return this.tokenize(this.value).stream().anyMatch(set::contains);
            }
            case MATCH_ALL: {
                return this.tokenize(this.value).stream().allMatch(set::contains);
            }
            case RANGE: {
                return !(this.value != null && s.compareTo(this.value) < 0 || this.otherValue != null && s.compareTo(this.otherValue) > 0);
            }
        }
        return true;
    }

    public boolean verify(boolean b, ConditionOperator operator) {
        switch (operator) {
            case EXACT: 
            case MATCH_ANY: 
            case MATCH_ALL: {
                return b == this.value.equalsIgnoreCase("true");
            }
        }
        return false;
    }

    public boolean verify(double n, ConditionOperator operator) {
        switch (operator) {
            case EXACT: 
            case MATCH_ANY: 
            case MATCH_ALL: {
                return n == NumberUtils.toDouble((String)this.value, (double)0.0);
            }
            case RANGE: {
                return n >= NumberUtils.toDouble((String)this.value, (double)Double.MIN_VALUE) && n <= NumberUtils.toDouble((String)this.otherValue, (double)Double.MAX_VALUE);
            }
        }
        return false;
    }

    public boolean verify(Date date, ConditionOperator operator) {
        if (date == null) {
            return false;
        }
        switch (operator) {
            case EXACT: 
            case MATCH_ANY: 
            case MATCH_ALL: {
                return date.getTime() == DateParser.parse(this.value).getTime();
            }
            case RANGE: {
                Date min = DateParser.parse(this.value);
                Date max = DateParser.parse(this.otherValue);
                long t = date.getTime();
                return !(min != null && t < min.getTime() || max != null && t > max.getTime());
            }
        }
        return false;
    }

    private Set<String> tokenize(String s) {
        return Arrays.stream(s.replaceAll("[^a-zA-Z0-9]", " ").toLowerCase().split(" ")).map(String::trim).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
    }
}

