/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.controllers.AbstractLbsController;
import eu.dnetlib.broker.common.elasticsearch.EventRepository;
import eu.dnetlib.broker.common.elasticsearch.NotificationRepository;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.common.topics.TopicTypeRepository;
import eu.dnetlib.broker.controllers.objects.BufferStatus;
import eu.dnetlib.broker.controllers.objects.CurrentStatus;
import eu.dnetlib.broker.controllers.objects.DispatcherStatus;
import eu.dnetlib.broker.controllers.objects.ThreadStatus;
import eu.dnetlib.broker.controllers.objects.Tool;
import eu.dnetlib.broker.events.output.DispatcherManager;
import eu.dnetlib.broker.events.output.NotificationDispatcher;
import eu.dnetlib.broker.utils.LbsQueue;
import eu.dnetlib.broker.utils.QueueManager;
import eu.dnetlib.broker.utils.ThreadManager;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ajax"})
public class AjaxController
extends AbstractLbsController {
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private QueueManager queueManager;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private TopicTypeRepository topicTypeRepo;
    @Autowired
    private DispatcherManager dispatcherManager;
    @Autowired
    private CurrentStatus currentStatus;
    @Autowired
    private ThreadManager threadManager;
    @Value(value="${lbs.elastic.homepage}")
    private String elasticSearchUiUrl;

    @GetMapping(value={"externalTools"})
    public List<Tool> listExternalUrls() {
        ArrayList<Tool> tools = new ArrayList<Tool>();
        tools.add(new Tool("ElasticSearch", this.elasticSearchUiUrl));
        return tools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GetMapping(value={"summary"})
    public CurrentStatus eventSummary() {
        List buffers = this.queueManager.getLbsQueues().stream().map(q -> new BufferStatus(q.getName(), q.size(), q.getLostRecords(), q.getSkippedRecords(), q.getInvalidRecords())).sorted().collect(Collectors.toList());
        List dispatchers = this.dispatcherManager.getDispatchers().stream().map(d -> new DispatcherStatus(d.getDispatcherName(), d.count(), d.countErrors(), d.lastError())).sorted().collect(Collectors.toList());
        List threads = this.threadManager.getThreads().stream().map(t -> new ThreadStatus(t.getName(), t.getState().toString(), t.isAlive())).sorted().collect(Collectors.toList());
        CurrentStatus currentStatus = this.currentStatus;
        synchronized (currentStatus) {
            this.currentStatus.setBuffers(buffers);
            this.currentStatus.setDispatchers(dispatchers);
            this.currentStatus.setThreads(threads);
            this.currentStatus.getTotals().put("topics", this.topicTypeRepo.count());
            this.currentStatus.getTotals().put("events", this.eventRepository.count());
            this.currentStatus.getTotals().put("subscriptions", this.subscriptionRepo.count());
            this.currentStatus.getTotals().put("notifications", this.notificationRepository.count());
            return this.currentStatus;
        }
    }

    @GetMapping(value={"/resetCounters"})
    public CurrentStatus resetCounters() {
        this.dispatcherManager.getDispatchers().forEach(NotificationDispatcher::resetCount);
        this.queueManager.getLbsQueues().forEach(LbsQueue::resetCounters);
        return this.eventSummary();
    }
}

