/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.controllers.AbstractLbsController;
import eu.dnetlib.broker.common.elasticsearch.NotificationRepository;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.controllers.InSubscription;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/subscriptions"})
@Api(tags={"Subscriptions"})
public class SubscriptionsController
extends AbstractLbsController {
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private NotificationRepository notificationRepo;
    public static final Predicate<String> verifyTopic = Pattern.compile("^([a-zA-Z0-9._-]+(\\/[a-zA-Z0-9._-]+)+)|\\*$").asPredicate();
    public static final Predicate<String> verifyEmail = email -> {
        try {
            new InternetAddress(email).validate();
            return true;
        }
        catch (AddressException e) {
            return false;
        }
    };

    @ApiOperation(value="Return the list of subscriptions")
    @GetMapping(value={""})
    public Iterable<Subscription> listSubscriptions() {
        return this.subscriptionRepo.findAll();
    }

    @ApiOperation(value="Return a subscription by ID")
    @GetMapping(value={"/{id}"})
    public Subscription getSubscription(@PathVariable String id) {
        return (Subscription)this.subscriptionRepo.findById((Object)id).get();
    }

    @ApiOperation(value="Delete a subscription by ID and its notifications")
    @DeleteMapping(value={"/{id}"})
    public void deleteSubscription(@PathVariable String id) {
        this.subscriptionRepo.deleteById((Object)id);
        this.notificationRepo.deleteBySubscriptionId(id);
    }

    @ApiOperation(value="Perform a new subscription")
    @PostMapping(value={""})
    public Subscription registerSubscription(@RequestBody InSubscription inSub) {
        Subscription sub = inSub.asSubscription();
        this.subscriptionRepo.save((Object)sub);
        return sub;
    }

    @ApiOperation(value="Delete all subscriptions and notifications")
    @DeleteMapping(value={""})
    public Map<String, Object> clearSubscriptions() {
        HashMap<String, Object> res = new HashMap<String, Object>();
        this.subscriptionRepo.deleteAll();
        this.notificationRepo.deleteAll();
        res.put("deleted", "all");
        return res;
    }

    @ApiOperation(value="Reset the last notification date")
    @DeleteMapping(value={"/{id}/date"})
    public void deleteNotificationDate(@PathVariable String id) {
        Subscription s = (Subscription)this.subscriptionRepo.findById((Object)id).get();
        s.setLastNotificationDate(null);
        this.subscriptionRepo.save((Object)s);
    }

    @ApiOperation(value="Reset all the last notification dates")
    @GetMapping(value={"/resetLastNotificationDates"})
    public void deleteAllNotificationDates() {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            s.setLastNotificationDate(null);
            this.subscriptionRepo.save((Object)s);
        }
    }
}

