/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.cron;

import eu.dnetlib.broker.common.elasticsearch.EventRepository;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.matchers.SubscriptionEventMatcher;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!openaire"})
public class ScheduledActions {
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private SubscriptionEventMatcher subscriptionEventMatcher;
    private static final Log log = LogFactory.getLog(ScheduledActions.class);

    @Scheduled(cron="${lbs.task.deleteOldEvents.cron}")
    public long deleteExpiredEvents() {
        long n = this.eventRepository.deleteByExpiryDateBetween(0L, new Date().getTime());
        log.info((Object)("Number of deleted expired events: " + n));
        return n;
    }

    @Scheduled(cron="${lbs.task.subscriptionEventsMatcher.cron}")
    public void startSubscriptionEventsMatcher() {
        this.subscriptionRepo.findAll().forEach(arg_0 -> ((SubscriptionEventMatcher)this.subscriptionEventMatcher).startMatching(arg_0));
    }
}

