/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.openaire;

import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.elasticsearch.NotificationRepository;
import eu.dnetlib.broker.common.properties.ElasticSearchProperties;
import eu.dnetlib.broker.common.subscriptions.ConditionParams;
import eu.dnetlib.broker.common.subscriptions.MapCondition;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.events.output.DispatcherManager;
import eu.dnetlib.broker.objects.OaBrokerEventPayload;
import eu.dnetlib.broker.openaire.AdvQueryObject;
import eu.dnetlib.broker.openaire.BrowseEntry;
import eu.dnetlib.broker.openaire.ElasticSearchQueryUtils;
import eu.dnetlib.broker.openaire.EventsPage;
import eu.dnetlib.broker.openaire.OpenaireSubscription;
import eu.dnetlib.broker.openaire.Range;
import eu.dnetlib.broker.openaire.SimpleSubscriptionDesc;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.nested.ParsedNested;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchHits;
import org.springframework.data.elasticsearch.core.mapping.IndexCoordinates;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"openaire"})
@RestController
@RequestMapping(value={"/api/openaireBroker"})
@Api(tags={"OpenAIRE"})
public class OpenaireBrokerController
extends AbstractDnetController {
    @Autowired
    private ElasticsearchOperations esOperations;
    @Autowired
    private NotificationRepository notificationRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private ElasticSearchProperties props;
    @Autowired
    private DispatcherManager dispatcher;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    private static final Log log = LogFactory.getLog(OpenaireBrokerController.class);

    @ApiOperation(value="Return the datasources having events")
    @GetMapping(value={"/datasources"})
    public List<BrowseEntry> findDatasourcesWithEvents(@RequestParam(defaultValue="false", required=false) boolean useIndex) {
        return useIndex ? this.findDatasourcesWithEventsUsingIndex() : this.findDatasourcesWithEventsUsingDb();
    }

    private List<BrowseEntry> findDatasourcesWithEventsUsingIndex() {
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.matchAllQuery()).withSearchType(SearchType.DEFAULT).addAggregation(AggregationBuilders.nested((String)"nested", (String)"map").subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"by_map").field("map.targetDatasourceName")).size(1000).minDocCount(1L))).build();
        SearchHits hits = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        Aggregation aggByMap = (Aggregation)((ParsedNested)aggregations.asMap().get("nested")).getAggregations().asMap().get("by_map");
        return ((ParsedStringTerms)aggByMap).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    private List<BrowseEntry> findDatasourcesWithEventsUsingDb() {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/datasourceTopics.sql"));
            RowMapper mapper = (rs, rowNum) -> new BrowseEntry(rs.getString("name"), rs.getLong("size"));
            return this.jdbcTemplate.query(sql, mapper);
        }
        catch (Exception e) {
            log.error((Object)"Error executing query", (Throwable)e);
            return new ArrayList<BrowseEntry>();
        }
    }

    @ApiOperation(value="Return the topics of the events of a datasource")
    @GetMapping(value={"/topicsForDatasource"})
    public List<BrowseEntry> findTopicsForDatasource(@RequestParam String ds, @RequestParam(defaultValue="false", required=false) boolean useIndex) {
        return useIndex ? this.findTopicsForDatasourceUsingIndex(ds) : this.findTopicsForDatasourceUsingDb(ds);
    }

    private List<BrowseEntry> findTopicsForDatasourceUsingIndex(String ds) {
        String term = "topic.keyword";
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.targetDatasourceName", (Object)ds), (ScoreMode)ScoreMode.None)).withSearchType(SearchType.DEFAULT).addAggregation((AbstractAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"topic.keyword").field("topic.keyword")).size(1000).minDocCount(1L)).build();
        SearchHits hits = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        Aggregations aggregations = hits.getAggregations();
        return ((ParsedStringTerms)aggregations.asMap().get("topic.keyword")).getBuckets().stream().map(b -> new BrowseEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
    }

    private List<BrowseEntry> findTopicsForDatasourceUsingDb(String ds) {
        try {
            String sql = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/datasourceTopicsDetailed.sql"));
            RowMapper mapper = (rs, rowNum) -> new BrowseEntry(rs.getString("topic"), rs.getLong("size"));
            return this.jdbcTemplate.query(sql, new Object[]{ds}, mapper);
        }
        catch (Exception e) {
            log.error((Object)"Error executing query", (Throwable)e);
            return new ArrayList<BrowseEntry>();
        }
    }

    @ApiOperation(value="Return a page of events of a datasource (by topic)")
    @GetMapping(value={"/events/{nPage}/{size}"})
    public EventsPage showEvents(@RequestParam String ds, @RequestParam String topic, @PathVariable int nPage, @PathVariable int size) {
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"map", (QueryBuilder)QueryBuilders.matchQuery((String)"map.targetDatasourceName", (Object)ds), (ScoreMode)ScoreMode.None);
        NestedQueryBuilder q = StringUtils.isNotBlank((CharSequence)topic) && !topic.equals("*") ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)topic).operator(Operator.AND)).must((QueryBuilder)nestedQuery) : nestedQuery;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)q).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        SearchHits page = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        List list = page.stream().map(SearchHit::getContent).map(Event::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(ds, topic, (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
    }

    @ApiOperation(value="Return a page of events of a datasource (by query)")
    @PostMapping(value={"/events/{nPage}/{size}"})
    public EventsPage advancedShowEvents(@PathVariable int nPage, @PathVariable int size, @RequestBody AdvQueryObject qObj) {
        BoolQueryBuilder mapQuery = QueryBuilders.boolQuery();
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.targetDatasourceName", (String)qObj.getDatasource());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.targetResultTitle", (List)qObj.getTitles());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.targetAuthors", (List)qObj.getAuthors());
        ElasticSearchQueryUtils.addMapCondition((BoolQueryBuilder)mapQuery, (String)"map.targetSubjects", (List)qObj.getSubjects());
        ElasticSearchQueryUtils.addMapConditionForTrust((BoolQueryBuilder)mapQuery, (String)"map.trust", (Range)qObj.getTrust());
        ElasticSearchQueryUtils.addMapConditionForDates((BoolQueryBuilder)mapQuery, (String)"map.targetDateofacceptance", (List)qObj.getDates());
        NestedQueryBuilder nestedQuery = QueryBuilders.nestedQuery((String)"map", (QueryBuilder)mapQuery, (ScoreMode)ScoreMode.None);
        NestedQueryBuilder q = StringUtils.isNotBlank((CharSequence)qObj.getTopic()) && !qObj.getTopic().equals("*") ? QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)"topic", (Object)qObj.getTopic()).operator(Operator.AND)).must((QueryBuilder)nestedQuery) : nestedQuery;
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)q).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
        SearchHits page = this.esOperations.search((Query)searchQuery, Event.class, IndexCoordinates.of((String[])new String[]{this.props.getEventsIndexName()}));
        List list = page.stream().map(SearchHit::getContent).map(Event::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
        return new EventsPage(qObj.getDatasource(), qObj.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
    }

    @ApiOperation(value="Perform a subscription")
    @PostMapping(value={"/subscribe"})
    public Subscription registerSubscription(@RequestBody OpenaireSubscription oSub) {
        Subscription sub = oSub.asSubscription();
        this.subscriptionRepo.save((Object)sub);
        return sub;
    }

    @ApiOperation(value="Return the subscriptions of an user (by email and datasource (optional))")
    @GetMapping(value={"/subscriptions"})
    public Map<String, List<SimpleSubscriptionDesc>> subscriptions(@RequestParam String email, @RequestParam(required=false) String ds) {
        Iterable iter = this.subscriptionRepo.findBySubscriber(email);
        return StreamSupport.stream(iter.spliterator(), false).map(arg_0 -> this.subscriptionDesc(arg_0)).filter(s -> StringUtils.isBlank((CharSequence)ds) || StringUtils.equalsIgnoreCase((CharSequence)s.getDatasource(), (CharSequence)ds)).collect(Collectors.groupingBy(SimpleSubscriptionDesc::getDatasource));
    }

    @ApiOperation(value="Return a page of notifications")
    @GetMapping(value={"/notifications/{subscrId}/{nPage}/{size}"})
    public EventsPage notifications(@PathVariable String subscrId, @PathVariable int nPage, @PathVariable int size) {
        Optional optSub = this.subscriptionRepo.findById((Object)subscrId);
        if (optSub.isPresent()) {
            Subscription sub = (Subscription)optSub.get();
            NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withQuery((QueryBuilder)QueryBuilders.termQuery((String)"subscriptionId.keyword", (String)subscrId)).withSearchType(SearchType.DEFAULT).withFields(new String[]{"payload"}).withPageable((Pageable)PageRequest.of((int)nPage, (int)size)).build();
            SearchHits page = this.esOperations.search((Query)searchQuery, Notification.class, IndexCoordinates.of((String[])new String[]{this.props.getNotificationsIndexName()}));
            List list = page.stream().map(SearchHit::getContent).map(Notification::getPayload).map(OaBrokerEventPayload::fromJSON).collect(Collectors.toList());
            return new EventsPage(this.extractDatasource(sub), sub.getTopic(), (long)nPage, this.overrideGetTotalPage(page, size), page.getTotalHits(), list);
        }
        log.warn((Object)("Invalid subscription: " + subscrId));
        return new EventsPage("", "", (long)nPage, 0L, 0L, new ArrayList());
    }

    @ApiOperation(value="Send notifications")
    @GetMapping(value={"/notifications/send/{date}"})
    private List<String> sendMailForNotifications(@PathVariable long date) {
        new Thread(() -> this.innerSendMailForNotifications(date)).start();
        return Arrays.asList("Sending ...");
    }

    @ApiOperation(value="Update stats")
    @GetMapping(value={"/stats/update"})
    private List<String> updateStats() {
        new Thread(() -> {
            try {
                this.jdbcTemplate.update(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/sql/updateStats.sql")));
            }
            catch (Exception e) {
                log.error((Object)"Error updating stats", (Throwable)e);
            }
        }).start();
        return Arrays.asList("Sending ...");
    }

    private void innerSendMailForNotifications(long date) {
        for (Subscription s : this.subscriptionRepo.findAll()) {
            long count = this.notificationRepository.countBySubscriptionIdAndDateAfter(s.getSubscriptionId(), date);
            if (count > 0L) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("oa_notifications_total", count);
                params.put("oa_datasource", this.extractDatasource(s));
                this.dispatcher.sendNotification(s, params);
            }
            s.setLastNotificationDate(new Date());
            this.subscriptionRepo.save((Object)s);
        }
    }

    private SimpleSubscriptionDesc subscriptionDesc(Subscription s) {
        return new SimpleSubscriptionDesc(s.getSubscriptionId(), this.extractDatasource(s), s.getTopic(), s.getCreationDate(), s.getLastNotificationDate(), this.notificationRepository.countBySubscriptionId(s.getSubscriptionId()));
    }

    private String extractDatasource(Subscription sub) {
        return sub.getConditionsAsList().stream().filter(c -> c.getField().equals("targetDatasourceName")).map(MapCondition::getListParams).filter(l -> !l.isEmpty()).map(l -> ((ConditionParams)l.get(0)).getValue()).findFirst().orElse("");
    }

    private long overrideGetTotalPage(SearchHits<?> page, int size) {
        return (page.getTotalHits() + (long)size - 1L) / (long)size;
    }
}

