/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.elasticsearch.Notification;
import eu.dnetlib.broker.common.elasticsearch.NotificationRepository;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notifications"})
@Api(tags={"Notifications"})
public class NotificationsController
extends AbstractDnetController {
    private static final Log log = LogFactory.getLog(NotificationsController.class);
    @Autowired
    private NotificationRepository notificationRepository;

    @ApiOperation(value="Return a notification by ID")
    @GetMapping(value={"/{id}"})
    public Notification getNotification(@PathVariable String id) {
        return (Notification)this.notificationRepository.findById((Object)id).get();
    }

    @ApiOperation(value="Delete a notification by ID")
    @DeleteMapping(value={"/{id}"})
    public void deleteNotification(@PathVariable String id) {
        this.notificationRepository.deleteById((Object)id);
    }

    @ApiOperation(value="Save a notification by ID")
    @PostMapping(value={"/{id}"})
    public Notification saveNotification(@RequestBody Notification notification) {
        return (Notification)this.notificationRepository.save((Object)notification);
    }

    @ApiOperation(value="Delete all notifications")
    @DeleteMapping(value={""})
    public void deleteAllNotifications() {
        this.notificationRepository.deleteAll();
    }

    @ApiOperation(value="Delete the notifications with the date in a range")
    @DeleteMapping(value={"/byDate/{from}/{to}"})
    public Map<String, Object> deleteNotificationsByDate(@PathVariable long from, @PathVariable long to) {
        new Thread(() -> {
            long n = this.notificationRepository.deleteByDateBetween(from, to);
            log.info((Object)String.format("Deleted %s notifications in date range %s-%s", n, from, to));
        }).start();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("status", "deleting...");
        res.put("from", from);
        res.put("to", to);
        return res;
    }
}

