/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import com.google.common.collect.Lists;
import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.elasticsearch.EventRepository;
import eu.dnetlib.broker.common.elasticsearch.EventStatsManager;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/events"})
@Api(tags={"Events"})
public class EventsController
extends AbstractDnetController {
    private static final Log log = LogFactory.getLog(AbstractDnetController.class);
    @Autowired
    private EventRepository eventRepository;
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired
    private EventStatsManager eventStatsManager;

    @ApiOperation(value="Return an event by ID")
    @GetMapping(value={"/{id}"})
    public Event getEvent(@PathVariable String id) {
        return (Event)this.eventRepository.findById((Object)id).get();
    }

    @ApiOperation(value="Delete an event by ID")
    @DeleteMapping(value={"/{id}"})
    public void deleteEvent(@PathVariable String id) {
        this.eventRepository.deleteById((Object)id);
    }

    @ApiOperation(value="Save an event by ID")
    @PostMapping(value={"/{id}"})
    public Event saveEvent(@RequestBody Event event) {
        return (Event)this.eventRepository.save((Object)event);
    }

    @ApiOperation(value="Return a page of events")
    @GetMapping(value={"/list/{page}/{pageSize}"})
    public List<Event> events(@PathVariable int page, @PathVariable int pageSize) {
        return Lists.newArrayList((Iterable)this.eventRepository.findAll((Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @ApiOperation(value="Return a page of events by topic")
    @GetMapping(value={"/byTopic/{page}/{pageSize}"})
    public List<Event> eventsByTopic(@PathVariable int page, @PathVariable int pageSize, @RequestParam String topic) {
        return Lists.newArrayList((Iterable)this.eventRepository.findByTopic(topic, (Pageable)PageRequest.of((int)page, (int)pageSize)));
    }

    @ApiOperation(value="Delete all the events")
    @DeleteMapping(value={"/all"})
    public Map<String, Object> clearEvents() {
        this.eventRepository.deleteAll();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("deleted", true);
        return res;
    }

    @ApiOperation(value="Delete the expired events")
    @DeleteMapping(value={"/expired"})
    public Map<String, Object> deleteExpiredEvents() {
        return this.deleteEventsByExpiryDate(0L, new Date().getTime());
    }

    @ApiOperation(value="Delete the events with the creationDate in a range")
    @DeleteMapping(value={"/byCreationDate/{from}/{to}"})
    public Map<String, Long> deleteEventsByCreationDate(@PathVariable long from, @PathVariable long to) {
        HashMap<String, Long> res = new HashMap<String, Long>();
        res.put("deleted", this.eventRepository.deleteByCreationDateBetween(from, to));
        res.put("from", from);
        res.put("to", to);
        log.info((Object)String.format("Deleted %s events in creationDate range %s-%s", res.get("deleted"), from, to));
        return res;
    }

    @ApiOperation(value="Delete the events with the expiryDate in a range")
    @DeleteMapping(value={"/byExpiryDate/{from}/{to}"})
    public Map<String, Object> deleteEventsByExpiryDate(@PathVariable long from, @PathVariable long to) {
        new Thread(() -> {
            long n = this.eventRepository.deleteByExpiryDateBetween(from, to);
            log.info((Object)String.format("Deleted %s events in expiryDate range %s-%s", n, from, to));
        }).start();
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("status", "deleting...");
        res.put("from", from);
        res.put("to", to);
        return res;
    }

    @ApiOperation(value="Return the topics of the indexed events (all)")
    @GetMapping(value={"/topics/all"})
    public List<EventStatsManager.BrowseEntry> browseTopics() {
        return this.eventStatsManager.browseTopics();
    }

    @ApiOperation(value="Return the topics of the indexed events (only with subscriptions)")
    @GetMapping(value={"/topics/withSubscriptions"})
    public List<EventStatsManager.BrowseEntry> browseTopicsWithSubscriptions() {
        Iterable iter = this.subscriptionRepo.findAll();
        Set validTopics = StreamSupport.stream(iter.spliterator(), false).map(Subscription::getTopic).collect(Collectors.toSet());
        return this.browseTopics().stream().filter(e -> validTopics.contains(e.getValue())).collect(Collectors.toList());
    }
}

