/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.controllers;

import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.common.subscriptions.SubscriptionRepository;
import eu.dnetlib.broker.matchers.SubscriptionEventMatcher;
import eu.dnetlib.common.controller.AbstractDnetController;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Profile;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Profile(value={"!openaire"})
@RestController
@RequestMapping(value={"/api/matching"})
@Tag(name="Subscription-Event Matching")
public class StartMatchingController
extends AbstractDnetController {
    @Autowired
    private SubscriptionRepository subscriptionRepo;
    @Autowired(required=false)
    private SubscriptionEventMatcher subscriptionEventMatcher;

    @Operation(summary="Launch the thread that produces new notifications")
    @GetMapping(value={"/start"})
    public List<String> startMatching() {
        if (this.subscriptionEventMatcher != null) {
            this.subscriptionRepo.findAll().forEach(arg_0 -> ((SubscriptionEventMatcher)this.subscriptionEventMatcher).startMatching(arg_0));
            return Arrays.asList("done");
        }
        return Arrays.asList("matching is disabled");
    }

    @Operation(summary="Launch the thread that produces new notifications by subscriptuion id")
    @GetMapping(value={"/start/{subscriptionId}"})
    public List<String> startMatching(@PathVariable String subscriptionId) {
        Optional s = this.subscriptionRepo.findById((Object)subscriptionId);
        if (this.subscriptionEventMatcher == null) {
            return Arrays.asList("matching is disabled");
        }
        if (s.isPresent()) {
            this.subscriptionEventMatcher.startMatching((Subscription)s.get());
            return Arrays.asList("done");
        }
        return Arrays.asList("subscription not present");
    }
}

