/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker.events.output;

import eu.dnetlib.broker.common.elasticsearch.Event;
import eu.dnetlib.broker.common.subscriptions.NotificationMode;
import eu.dnetlib.broker.common.subscriptions.Subscription;
import eu.dnetlib.broker.events.output.AbstractNotificationDispatcher;
import java.io.StringWriter;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"dev"})
public class MockDispatcher
extends AbstractNotificationDispatcher<String> {
    private static final Log log = LogFactory.getLog(MockDispatcher.class);

    protected String prepareAction(Subscription subscription, Event ... events) throws Exception {
        StringWriter sw = new StringWriter();
        sw.write("\n********************************");
        sw.write("\n* New notification");
        sw.write("\n*  -  Subscription : " + subscription);
        sw.write("\n*  -  N. events    : " + events.length);
        sw.write("\n********************************");
        return sw.toString();
    }

    protected String prepareAction(Subscription subscription, Map<String, Object> params) throws Exception {
        StringWriter sw = new StringWriter();
        sw.write("\n********************************");
        sw.write("\n* New notification");
        sw.write("\n*  -  Subscription : " + subscription);
        params.entrySet().forEach(e -> sw.write("\n*  -  " + (String)e.getKey() + ": " + e.getValue()));
        sw.write("\n********************************");
        return sw.toString();
    }

    protected void performAction(String message) throws Exception {
        log.info((Object)message);
    }

    public NotificationMode getMode() {
        return NotificationMode.MOCK;
    }
}

