package eu.dnetlib.broker.openaireAlerts;

public class DatasourceWithAlert implements Comparable<DatasourceWithAlert> {

	public final String id;
	public final String name;
	public final String rule;
	public final long size;

	public DatasourceWithAlert(final String id, final String name, final String rule, final long size) {
		this.id = id;
		this.name = name;
		this.rule = rule;
		this.size = size;
	}

	@Override
	public int compareTo(final DatasourceWithAlert bv) {
		return Long.compare(getSize(), bv.getSize());
	}

	public String getId() {
		return id;
	}

	public String getName() {
		return name;
	}

	public String getRule() {
		return rule;
	}

	public long getSize() {
		return size;
	}

}
