/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.broker;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.configurationprocessor.json.JSONArray;
import org.springframework.boot.configurationprocessor.json.JSONException;
import org.springframework.boot.configurationprocessor.json.JSONObject;
import org.springframework.stereotype.Component;

@Component
@Deprecated
public class BrokerUtils {
    private static final Logger log = LoggerFactory.getLogger(BrokerUtils.class);
    private static final HttpClient client = HttpClientBuilder.create().build();

    public List<String> listSubscriptions(URL baseUrl, String email) throws Exception {
        String url = baseUrl + "/subscriptions?email=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name());
        log.info("Performing HTTP GET for subscriptions: " + url);
        HttpGet request = new HttpGet(url);
        request.addHeader("accept", "application/json");
        HttpResponse response = client.execute((HttpUriRequest)request);
        String json = IOUtils.toString((InputStream)response.getEntity().getContent());
        log.info("Found subscriptions: " + json);
        JSONArray array = new JSONArray(json);
        System.out.println(String.format("Found %d subscription(s):", array.length()));
        ArrayList<String> res = new ArrayList<String>();
        for (int i = 0; i < array.length(); ++i) {
            JSONObject object = array.getJSONObject(i);
            String suscrId = object.getString("subscriptionId");
            String topic = object.getString("topic");
            String ds = this.extractDsName(object.getJSONArray("conditionsAsList"));
            System.out.println(String.format(" - %s (TOPIC: %s, Datasource: %s)", suscrId, topic, ds));
            res.add(suscrId);
        }
        System.out.println();
        return res;
    }

    public void downloadEvents(URL baseUrl, String subscrId, File outputDir, boolean gzip) throws Exception {
        block37: {
            String fp = String.format(gzip ? "%s/%s.json.gz" : "%s/%s.json", outputDir.getAbsolutePath(), subscrId);
            System.out.print("Saving file " + fp + ": ");
            System.out.flush();
            if (gzip) {
                try (FileOutputStream fos = new FileOutputStream(fp);
                     OutputStreamWriter w = new OutputStreamWriter((OutputStream)new GZIPOutputStream(fos), "UTF-8");){
                    this.writeEvents(baseUrl, subscrId, (Writer)w);
                    break block37;
                }
            }
            try (FileWriter fw = new FileWriter(fp);){
                this.writeEvents(baseUrl, subscrId, (Writer)fw);
            }
        }
        System.out.println();
    }

    private void writeEvents(URL baseUrl, String subscrId, Writer file) throws Exception {
        String url = baseUrl + "/scroll/notifications/bySubscriptionId/" + URLEncoder.encode(subscrId, StandardCharsets.UTF_8.name());
        boolean notCompleted = false;
        boolean first = true;
        file.append("[\n");
        do {
            log.info("Performing HTTP GET for notifications: " + url);
            HttpGet request = new HttpGet(url);
            request.addHeader("accept", "application/json");
            HttpResponse response = client.execute((HttpUriRequest)request);
            String json = IOUtils.toString((InputStream)response.getEntity().getContent());
            JSONObject data = new JSONObject(json);
            JSONArray values = data.getJSONArray("values");
            for (int i = 0; i < values.length(); ++i) {
                if (first) {
                    first = false;
                } else {
                    file.append(",\n");
                }
                file.append(values.getJSONObject(i).toString());
            }
            notCompleted = !data.getBoolean("completed");
            url = baseUrl + "/scroll/notifications/" + data.getString("id");
            System.out.print(".");
            System.out.flush();
        } while (notCompleted);
        file.append("\n]\n");
    }

    private String extractDsName(JSONArray conds) {
        try {
            for (int i = 0; i < conds.length(); ++i) {
                JSONObject object = conds.getJSONObject(i);
                if (!object.getString("field").equals("targetDatasourceName")) continue;
                return object.getJSONArray("listParams").getJSONObject(0).getString("value");
            }
        }
        catch (JSONException e) {
            log.warn(e.getMessage());
        }
        return "";
    }
}

