/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.broker.model.Event;
import eu.dnetlib.dhp.broker.model.EventFactory;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingAbstract;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingAuthorOrcid;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingDatasetIsReferencedBy;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingDatasetIsRelatedTo;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingDatasetIsSupplementedBy;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingDatasetIsSupplementedTo;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingDatasetReferences;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingOpenAccess;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPid;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingProject;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationDate;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationIsReferencedBy;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationIsRelatedTo;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationIsSupplementedBy;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationIsSupplementedTo;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingPublicationReferences;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingSoftware;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMissingSubject;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMoreOpenAccess;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMorePid;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMoreProject;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMoreSoftware;
import eu.dnetlib.dhp.broker.oa.matchers.EnrichMoreSubject;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateEventsApplication {
    private static final Logger log = LoggerFactory.getLogger(GenerateEventsApplication.class);
    private static final UpdateMatcher<Result, ?> enrichMissingAbstract = new EnrichMissingAbstract();
    private static final UpdateMatcher<Result, ?> enrichMissingAuthorOrcid = new EnrichMissingAuthorOrcid();
    private static final UpdateMatcher<Result, ?> enrichMissingOpenAccess = new EnrichMissingOpenAccess();
    private static final UpdateMatcher<Result, ?> enrichMissingPid = new EnrichMissingPid();
    private static final UpdateMatcher<Result, ?> enrichMissingPublicationDate = new EnrichMissingPublicationDate();
    private static final UpdateMatcher<Result, ?> enrichMissingSubject = new EnrichMissingSubject();
    private static final UpdateMatcher<Result, ?> enrichMoreOpenAccess = new EnrichMoreOpenAccess();
    private static final UpdateMatcher<Result, ?> enrichMorePid = new EnrichMorePid();
    private static final UpdateMatcher<Result, ?> enrichMoreSubject = new EnrichMoreSubject();
    private static final UpdateMatcher<Pair<Result, List<Project>>, ?> enrichMissingProject = new EnrichMissingProject();
    private static final UpdateMatcher<Pair<Result, List<Project>>, ?> enrichMoreProject = new EnrichMoreProject();
    private static final UpdateMatcher<Pair<Result, List<Software>>, ?> enrichMissingSoftware = new EnrichMissingSoftware();
    private static final UpdateMatcher<Pair<Result, List<Software>>, ?> enrichMoreSoftware = new EnrichMoreSoftware();
    private static final UpdateMatcher<Pair<Result, List<Publication>>, ?> enrichMisissingPublicationIsRelatedTo = new EnrichMissingPublicationIsRelatedTo();
    private static final UpdateMatcher<Pair<Result, List<Publication>>, ?> enrichMissingPublicationIsReferencedBy = new EnrichMissingPublicationIsReferencedBy();
    private static final UpdateMatcher<Pair<Result, List<Publication>>, ?> enrichMissingPublicationReferences = new EnrichMissingPublicationReferences();
    private static final UpdateMatcher<Pair<Result, List<Publication>>, ?> enrichMissingPublicationIsSupplementedTo = new EnrichMissingPublicationIsSupplementedTo();
    private static final UpdateMatcher<Pair<Result, List<Publication>>, ?> enrichMissingPublicationIsSupplementedBy = new EnrichMissingPublicationIsSupplementedBy();
    private static final UpdateMatcher<Pair<Result, List<Dataset>>, ?> enrichMisissingDatasetIsRelatedTo = new EnrichMissingDatasetIsRelatedTo();
    private static final UpdateMatcher<Pair<Result, List<Dataset>>, ?> enrichMissingDatasetIsReferencedBy = new EnrichMissingDatasetIsReferencedBy();
    private static final UpdateMatcher<Pair<Result, List<Dataset>>, ?> enrichMissingDatasetReferences = new EnrichMissingDatasetReferences();
    private static final UpdateMatcher<Pair<Result, List<Dataset>>, ?> enrichMissingDatasetIsSupplementedTo = new EnrichMissingDatasetIsSupplementedTo();
    private static final UpdateMatcher<Pair<Result, List<Dataset>>, ?> enrichMissingDatasetIsSupplementedBy = new EnrichMissingDatasetIsSupplementedBy();
    public static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)GenerateEventsApplication.class.getResourceAsStream("/eu/dnetlib/dhp/oa/graph/merge_claims_parameters.json")));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String graphPath = parser.get("graphPath");
        log.info("graphPath: {}", (Object)graphPath);
        String eventsPath = parser.get("eventsPath");
        log.info("eventsPath: {}", (Object)eventsPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
            GenerateEventsApplication.removeOutputDir(spark, eventsPath);
            JavaRDD eventsRdd = sc.emptyRDD();
            eventsRdd.union(GenerateEventsApplication.generateSimpleEvents(spark, graphPath, Publication.class));
            eventsRdd.union(GenerateEventsApplication.generateSimpleEvents(spark, graphPath, Dataset.class));
            eventsRdd.union(GenerateEventsApplication.generateSimpleEvents(spark, graphPath, Software.class));
            eventsRdd.union(GenerateEventsApplication.generateSimpleEvents(spark, graphPath, OtherResearchProduct.class));
            eventsRdd.saveAsTextFile(eventsPath, GzipCodec.class);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    private static <R extends Result> JavaRDD<Event> generateSimpleEvents(SparkSession spark, String graphPath, Class<R> resultClazz) {
        org.apache.spark.sql.Dataset results = GenerateEventsApplication.readPath(spark, graphPath + "/" + resultClazz.getSimpleName().toLowerCase(), resultClazz).filter((FilterFunction & Serializable)r -> r.getDataInfo().getDeletedbyinference());
        org.apache.spark.sql.Dataset rels = GenerateEventsApplication.readPath(spark, graphPath + "/relation", Relation.class).filter((FilterFunction & Serializable)r -> r.getRelClass().equals("isMergedIn"));
        Column c = null;
        org.apache.spark.sql.Dataset aa = results.joinWith(rels, results.col("id").equalTo((Object)rels.col("source")), "inner").groupBy(new Column[]{rels.col("target")}).agg(c, new Column[0]).filter((FilterFunction & Serializable)x -> x.size() > 1);
        return null;
    }

    private List<Event> generateSimpleEvents(Collection<Result> children) {
        ArrayList list = new ArrayList();
        for (Result target : children) {
            list.addAll(enrichMissingAbstract.searchUpdatesForRecord(target, children));
            list.addAll(enrichMissingAuthorOrcid.searchUpdatesForRecord(target, children));
            list.addAll(enrichMissingOpenAccess.searchUpdatesForRecord(target, children));
            list.addAll(enrichMissingPid.searchUpdatesForRecord(target, children));
            list.addAll(enrichMissingPublicationDate.searchUpdatesForRecord(target, children));
            list.addAll(enrichMissingSubject.searchUpdatesForRecord(target, children));
            list.addAll(enrichMoreOpenAccess.searchUpdatesForRecord(target, children));
            list.addAll(enrichMorePid.searchUpdatesForRecord(target, children));
            list.addAll(enrichMoreSubject.searchUpdatesForRecord(target, children));
        }
        return list.stream().map(EventFactory::newBrokerEvent).collect(Collectors.toList());
    }

    private List<Event> generateProjectsEvents(Collection<Pair<Result, List<Project>>> childrenWithProjects) {
        ArrayList list = new ArrayList();
        for (Pair<Result, List<Project>> target : childrenWithProjects) {
            list.addAll(enrichMissingProject.searchUpdatesForRecord(target, childrenWithProjects));
            list.addAll(enrichMoreProject.searchUpdatesForRecord(target, childrenWithProjects));
        }
        return list.stream().map(EventFactory::newBrokerEvent).collect(Collectors.toList());
    }

    private List<Event> generateSoftwareEvents(Collection<Pair<Result, List<Software>>> childrenWithSoftwares) {
        ArrayList list = new ArrayList();
        for (Pair<Result, List<Software>> target : childrenWithSoftwares) {
            list.addAll(enrichMissingSoftware.searchUpdatesForRecord(target, childrenWithSoftwares));
            list.addAll(enrichMoreSoftware.searchUpdatesForRecord(target, childrenWithSoftwares));
        }
        return list.stream().map(EventFactory::newBrokerEvent).collect(Collectors.toList());
    }

    private List<Event> generatePublicationRelatedEvents(String relType, Collection<Pair<Result, Map<String, List<Publication>>>> childrenWithRels) {
        ArrayList list = new ArrayList();
        List cleanedChildrens = childrenWithRels.stream().filter(p -> ((Map)p.getRight()).containsKey(relType)).map(p -> Pair.of((Object)p.getLeft(), ((Map)p.getRight()).get(relType))).filter(p -> ((List)p.getRight()).size() > 0).collect(Collectors.toList());
        for (Pair target : cleanedChildrens) {
            if (relType.equals("isRelatedTo")) {
                list.addAll(enrichMisissingPublicationIsRelatedTo.searchUpdatesForRecord((Pair<Result, List<Publication>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("references")) {
                list.addAll(enrichMissingPublicationReferences.searchUpdatesForRecord((Pair<Result, List<Publication>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("isReferencedBy")) {
                list.addAll(enrichMissingPublicationIsReferencedBy.searchUpdatesForRecord((Pair<Result, List<Publication>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("isSupplementedTo")) {
                list.addAll(enrichMissingPublicationIsSupplementedTo.searchUpdatesForRecord((Pair<Result, List<Publication>>)target, cleanedChildrens));
                continue;
            }
            if (!relType.equals("isSupplementedBy")) continue;
            list.addAll(enrichMissingPublicationIsSupplementedBy.searchUpdatesForRecord((Pair<Result, List<Publication>>)target, cleanedChildrens));
        }
        return list.stream().map(EventFactory::newBrokerEvent).collect(Collectors.toList());
    }

    private List<Event> generateDatasetRelatedEvents(String relType, Collection<Pair<Result, Map<String, List<Dataset>>>> childrenWithRels) {
        ArrayList list = new ArrayList();
        List cleanedChildrens = childrenWithRels.stream().filter(p -> ((Map)p.getRight()).containsKey(relType)).map(p -> Pair.of((Object)p.getLeft(), ((Map)p.getRight()).get(relType))).filter(p -> ((List)p.getRight()).size() > 0).collect(Collectors.toList());
        for (Pair target : cleanedChildrens) {
            if (relType.equals("isRelatedTo")) {
                list.addAll(enrichMisissingDatasetIsRelatedTo.searchUpdatesForRecord((Pair<Result, List<Dataset>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("references")) {
                list.addAll(enrichMissingDatasetReferences.searchUpdatesForRecord((Pair<Result, List<Dataset>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("isReferencedBy")) {
                list.addAll(enrichMissingDatasetIsReferencedBy.searchUpdatesForRecord((Pair<Result, List<Dataset>>)target, cleanedChildrens));
                continue;
            }
            if (relType.equals("isSupplementedTo")) {
                list.addAll(enrichMissingDatasetIsSupplementedTo.searchUpdatesForRecord((Pair<Result, List<Dataset>>)target, cleanedChildrens));
                continue;
            }
            if (!relType.equals("isSupplementedBy")) continue;
            list.addAll(enrichMissingDatasetIsSupplementedBy.searchUpdatesForRecord((Pair<Result, List<Dataset>>)target, cleanedChildrens));
        }
        return list.stream().map(EventFactory::newBrokerEvent).collect(Collectors.toList());
    }

    public static <R> org.apache.spark.sql.Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

