/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.broker.objects.Pid;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class EnrichMissingPid
extends UpdateMatcher<Result, Pid> {
    public EnrichMissingPid() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Pid>> findUpdates(Result source, Result target) {
        long count = target.getPid().size();
        if (count > 0L) {
            return Arrays.asList(new UpdateInfo[0]);
        }
        return source.getPid().stream().map(ConversionUtils::oafPidToBrokerPid).map(i -> this.generateUpdateInfo((Pid)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Pid> generateUpdateInfo(Pid highlightValue, Result source, Result target) {
        return new UpdateInfo<Pid>(Topic.ENRICH_MISSING_PID, highlightValue, source, target, (p, pid) -> p.getPids().add(pid), pid -> pid.getType() + "::" + pid.getValue());
    }
}

