/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class EnrichMissingSubject
extends UpdateMatcher<Result, Pair<String, String>> {
    public EnrichMissingSubject() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Pair<String, String>>> findUpdates(Result source, Result target) {
        Set existingTypes = target.getSubject().stream().map(StructuredProperty::getQualifier).map(Qualifier::getClassid).collect(Collectors.toSet());
        return source.getPid().stream().filter(pid -> !existingTypes.contains(pid.getQualifier().getClassid())).map(ConversionUtils::oafSubjectToPair).map(i -> this.generateUpdateInfo((Pair<String, String>)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Pair<String, String>> generateUpdateInfo(Pair<String, String> highlightValue, Result source, Result target) {
        return new UpdateInfo<Pair<String, String>>(Topic.fromPath("ENRICH/MISSING/SUBJECT/" + (String)highlightValue.getLeft()), highlightValue, source, target, (p, pair) -> p.getSubjects().add(pair.getRight()), pair -> (String)pair.getLeft() + "::" + (String)pair.getRight());
    }
}

