/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.broker.oa.matchers;

import eu.dnetlib.broker.objects.Instance;
import eu.dnetlib.dhp.broker.model.Topic;
import eu.dnetlib.dhp.broker.oa.matchers.UpdateMatcher;
import eu.dnetlib.dhp.broker.oa.util.ConversionUtils;
import eu.dnetlib.dhp.broker.oa.util.UpdateInfo;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EnrichMoreOpenAccess
extends UpdateMatcher<Result, Instance> {
    public EnrichMoreOpenAccess() {
        super(true);
    }

    @Override
    protected List<UpdateInfo<Instance>> findUpdates(Result source, Result target) {
        Set urls = target.getInstance().stream().filter(i -> i.getAccessright().getClassid().equals("OPEN")).map(i -> i.getUrl()).flatMap(Collection::stream).collect(Collectors.toSet());
        return source.getInstance().stream().filter(i -> i.getAccessright().getClassid().equals("OPEN")).map(ConversionUtils::oafInstanceToBrokerInstances).flatMap(s -> s).filter(i -> !urls.contains(i.getUrl())).map(i -> this.generateUpdateInfo((Instance)i, source, target)).collect(Collectors.toList());
    }

    @Override
    public UpdateInfo<Instance> generateUpdateInfo(Instance highlightValue, Result source, Result target) {
        return new UpdateInfo<Instance>(Topic.ENRICH_MORE_OA_VERSION, highlightValue, source, target, (p, i) -> p.getInstances().add(i), Instance::getUrl);
    }
}

